"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdatedByLabel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_bulk_get_user_profiles = require("../../../../common/components/user_profiles/use_bulk_get_user_profiles");
var _formatted_date = require("../../../../common/components/formatted_date");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/common/components/updated_by_label/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UpdatedByLabel = exports.UpdatedByLabel = /*#__PURE__*/_react.default.memo(({
  updatedBy,
  updatedAt
}) => {
  var _userProfile$user$ful;
  const userProfileId = (0, _react.useMemo)(() => new Set([updatedBy]), [updatedBy]);
  const {
    isLoading: isLoadingUserProfiles,
    data: userProfiles
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids: userProfileId
  });
  if (isLoadingUserProfiles || !(userProfiles !== null && userProfiles !== void 0 && userProfiles.length)) {
    return null;
  }
  const userProfile = userProfiles[0];
  const updatedByName = (_userProfile$user$ful = userProfile.user.full_name) !== null && _userProfile$user$ful !== void 0 ? _userProfile$user$ful : userProfile.user.username;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "updated_at",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.siemMigrations.rules.translationDetails.updatedByLabel",
    defaultMessage: "{updated}: {by} on {date}",
    values: {
      updated: /*#__PURE__*/_react.default.createElement("b", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 22
        }
      }, i18n.LAST_UPDATED_LABEL),
      by: updatedByName,
      date: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
        value: updatedAt,
        fieldName: "updated_at",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 19
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }));
});
UpdatedByLabel.displayName = 'UpdatedByLabel';