"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeDetailView = exports.NodeDetail = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _event_kinds = require("../../../flyout/document_details/shared/constants/event_kinds");
var _styles = require("./styles");
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var eventModel = _interopRequireWildcard(require("../../../../common/endpoint/models/event"));
var _generated_text = require("../generated_text");
var _cell_actions = require("../../../common/components/cell_actions");
var _helpers = require("../../../helpers");
var _breadcrumbs = require("./breadcrumbs");
var _process_event = require("../../models/process_event");
var nodeDataModel = _interopRequireWildcard(require("../../models/node_data"));
var _cube_for_process = require("./cube_for_process");
var _use_cube_assets = require("../use_cube_assets");
var _panel_loading = require("./panel_loading");
var _use_link_props = require("../use_link_props");
var _use_formatted_date = require("./use_formatted_date");
var _panel_content_error = require("./panel_content_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/panels/node_detail.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledCubeForProcess = (0, _styledComponents.default)(_cube_for_process.CubeForProcess)`
  position: relative;
`;
const nodeDetailError = _i18n.i18n.translate('xpack.securitySolution.resolver.panel.nodeDetail.Error', {
  defaultMessage: 'Node details were unable to be retrieved'
});

// eslint-disable-next-line react/display-name
const NodeDetail = exports.NodeDetail = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  nodeID,
  nodeEventOnClick
}) {
  const processEvent = (0, _reactRedux.useSelector)(state => nodeDataModel.firstEvent(selectors.nodeDataForID(state.analyzer[id])(nodeID)));
  const nodeStatus = (0, _reactRedux.useSelector)(state => selectors.nodeDataStatus(state.analyzer[id])(nodeID));
  return nodeStatus === 'loading' ? /*#__PURE__*/_react.default.createElement(_panel_loading.PanelLoading, {
    id: id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }) : processEvent ? /*#__PURE__*/_react.default.createElement(NodeDetailView, {
    id: id,
    nodeID: nodeID,
    processEvent: processEvent,
    nodeEventOnClick: nodeEventOnClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_panel_content_error.PanelContentError, {
    id: id,
    translatedErrorMessage: nodeDetailError,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  });
});
/**
 * A description list view of all the Metadata that goes with a particular process event, like:
 * Created, PID, User/Domain, etc.
 */
// eslint-disable-next-line react/display-name
const NodeDetailView = exports.NodeDetailView = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  processEvent,
  nodeID,
  nodeEventOnClick
}) {
  const processName = eventModel.processNameSafeVersion(processEvent);
  const nodeState = (0, _reactRedux.useSelector)(state => selectors.nodeDataStatus(state.analyzer[id])(nodeID));
  const relatedEventTotal = (0, _reactRedux.useSelector)(state => {
    return selectors.relatedEventTotalCount(state.analyzer[id])(nodeID);
  });
  const eventTime = eventModel.eventTimestamp(processEvent);
  const dateTime = (0, _use_formatted_date.useFormattedDate)(eventTime);
  const isAlert = eventModel.eventKind(processEvent)[0] === _event_kinds.EventKind.signal;
  const documentId = eventModel.documentID(processEvent);
  const indexName = eventModel.indexName(processEvent);
  const processInfoEntry = (0, _react.useMemo)(() => {
    const createdEntry = {
      title: '@timestamp',
      description: dateTime,
      value: eventTime
    };
    const pathEntry = {
      title: 'process.executable',
      description: (0, _process_event.processPath)(processEvent)
    };
    const pidEntry = {
      title: 'process.pid',
      description: (0, _process_event.processPID)(processEvent)
    };
    const userEntry = {
      title: 'user.name',
      description: eventModel.userName(processEvent)
    };
    const processEntityId = {
      title: 'process.entity_id',
      description: eventModel.entityId(processEvent)
    };
    const domainEntry = {
      title: 'user.domain',
      description: eventModel.userDomain(processEvent)
    };
    const parentPidEntry = {
      title: 'process.parent.pid',
      description: eventModel.parentPID(processEvent)
    };
    const md5Entry = {
      title: 'process.hash.md5',
      description: eventModel.md5HashForProcess(processEvent)
    };
    const commandLineEntry = {
      title: 'process.args',
      description: eventModel.argsForProcess(processEvent)
    };
    const flattenedEntries = [];
    const flattenedDescriptionListData = [createdEntry, pathEntry, pidEntry, processEntityId, userEntry, domainEntry, parentPidEntry, md5Entry, commandLineEntry].reduce((flattenedList, entry) => {
      if (Array.isArray(entry.description)) {
        return [...flattenedList, ...entry.description.map(value => {
          return {
            title: entry.title,
            description: value
          };
        })];
      } else {
        return [...flattenedList, entry];
      }
    }, flattenedEntries);

    // This is the data in {title, description} form for the EuiDescriptionList to display
    const processDescriptionListData = flattenedDescriptionListData.filter(entry => {
      return entry.description !== undefined;
    }).map(entry => {
      return {
        ...entry,
        description: String(entry.description)
      };
    });
    return processDescriptionListData;
  }, [dateTime, eventTime, processEvent]);
  const nodesLinkNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodes'
  });
  const crumbs = (0, _react.useMemo)(() => {
    return [{
      text: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.processDescList.events', {
        defaultMessage: 'Events'
      }),
      'data-test-subj': 'resolver:node-detail:breadcrumbs:node-list-link',
      ...nodesLinkNavProps
    }, {
      text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.resolver.panel.relatedEventDetail.detailsForProcessName",
        values: {
          processName
        },
        defaultMessage: "Details for: {processName}",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 228,
          columnNumber: 11
        }
      })
    }];
  }, [processName, nodesLinkNavProps]);
  const {
    descriptionText
  } = (0, _use_cube_assets.useCubeAssets)(id, nodeState, false);
  const nodeDetailNavProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeEvents',
    panelParameters: {
      nodeID
    }
  });
  const titleID = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)('resolverTable')(), []);
  const columns = [{
    field: 'title',
    'data-test-subj': 'resolver:node-detail:entry-title',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.resolver.panel.nodeDetail.fieldTitle",
      defaultMessage: "Field",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 9
      }
    }),
    width: 'fit-content(8em)',
    sortable: true,
    render(fieldName) {
      return /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 16
        }
      }, fieldName);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.resolver.panel.nodeDetail.valueTitle",
      defaultMessage: "Value",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 264,
        columnNumber: 9
      }
    }),
    'data-test-subj': 'resolver:node-detail:entry-description',
    render(data) {
      var _data$value;
      return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        data: {
          field: data.title,
          value: (_data$value = data.value) !== null && _data$value !== void 0 ? _data$value : data.description
        },
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        sourcererScopeId: (0, _helpers.getSourcererScopeId)(id),
        metadata: {
          scopeId: id
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 272,
          columnNumber: 11
        }
      }, data.description);
    }
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "resolver:panel:node-detail",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs: crumbs,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.StyledTitle, {
    "aria-describedby": titleID,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(StyledCubeForProcess, {
    id: id,
    "data-test-subj": "resolver:node-detail:title-icon",
    state: nodeState,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "resolver:node-detail:title",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 11
    }
  }, nodeEventOnClick ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "resolver:node-detail:title-link",
    onClick: nodeEventOnClick({
      documentId,
      indexName,
      scopeId: id,
      isAlert
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 17
    }
  }, processName)) : /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 15
    }
  }, processName)))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    id: titleID,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 11
    }
  }, descriptionText))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, nodeDetailNavProps, {
    "data-test-subj": "resolver:node-detail:node-events-link",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.panel.processDescList.numberOfEvents",
    values: {
      relatedEventTotal
    },
    defaultMessage: "{relatedEventTotal} Events",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "resolver:node-detail",
    items: processInfoEntry,
    columns: columns,
    sorting: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 7
    }
  }));
});