"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ancestorsRequestAmount = ancestorsRequestAmount;
exports.descendantsLimit = exports.ancestorsWithoutAncestryField = exports.ancestorsWithAncestryField = void 0;
exports.descendantsRequestAmount = descendantsRequestAmount;
exports.generationsRequestAmount = generationsRequestAmount;
exports.generationsWithoutAncestryField = exports.generationsWithAncestryField = void 0;
exports.mock = mock;
exports.nodeStats = nodeStats;
var nodeModel = _interopRequireWildcard(require("../../../common/endpoint/models/node"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * These values are only exported for testing. They should not be used directly. Instead use the functions below.
 */

/**
 * The limit for the ancestors in the server request when the ancestry field is defined in the schema.
 */
const ancestorsWithAncestryField = exports.ancestorsWithAncestryField = 200;
/**
 * The limit for the ancestors in the server request when the ancestry field is not defined in the schema.
 */
const ancestorsWithoutAncestryField = exports.ancestorsWithoutAncestryField = 20;
/**
 * The limit for the generations in the server request when the ancestry field is defined. Essentially this means
 * that the generations field will be ignored when the ancestry field is defined.
 */
const generationsWithAncestryField = exports.generationsWithAncestryField = 0;
/**
 * The limit for the generations in the server request when the ancestry field is not defined.
 */
const generationsWithoutAncestryField = exports.generationsWithoutAncestryField = 10;
/**
 * The limit for the descendants in the server request.
 */
const descendantsLimit = exports.descendantsLimit = 500;

/**
 * Returns the number of ancestors we should use when requesting a tree from the server
 * depending on whether the schema received from the server has the ancestry field defined.
 */
function ancestorsRequestAmount(schema) {
  return (schema === null || schema === void 0 ? void 0 : schema.ancestry) !== undefined ? ancestorsWithAncestryField : ancestorsWithoutAncestryField;
}

/**
 * Returns the number of generations we should use when requesting a tree from the server
 * depending on whether the schema received from the server has the ancestry field defined.
 */
function generationsRequestAmount(schema) {
  return (schema === null || schema === void 0 ? void 0 : schema.ancestry) !== undefined ? generationsWithAncestryField : generationsWithoutAncestryField;
}

/**
 * The number of the descendants to use in a request to the server for a resolver tree.
 */
function descendantsRequestAmount() {
  return descendantsLimit;
}

/**
 * This returns a map of nodeIDs to the associated stats provided by the datasource.
 */
function nodeStats(tree) {
  const stats = new Map();
  for (const node of tree.nodes) {
    if (node.stats) {
      const nodeID = nodeModel.nodeID(node);
      stats.set(nodeID, node.stats);
    }
  }
  return stats;
}

/**
 * ResolverTree type is returned by the server. It organizes events into a complex structure. The
 * organization of events in the tree is done to associate metadata with the events. The client does not
 * use this metadata. Instead, the client flattens the tree into an array. Therefore we can safely
 * make a malformed ResolverTree for the purposes of the tests, so long as it is flattened in a predictable way.
 */
function mock({
  nodes
}) {
  if (nodes.length === 0) {
    return null;
  }
  const originNode = nodes[0];
  const originID = nodeModel.nodeID(originNode);
  if (!originID) {
    throw new Error('first mock event must include an nodeID.');
  }
  return {
    originID,
    nodes
  };
}