"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CostSavings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _metrics = require("./metrics");
var _compare_percentage_badge = require("./compare_percentage_badge");
var _cost_savings_metric = require("./cost_savings_metric");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/cost_savings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CostSavings = ({
  minutesPerAlert,
  analystHourlyRate,
  from,
  to,
  costSavings,
  costSavingsCompare
}) => {
  const {
    euiTheme: {
      colors
    }
  } = (0, _eui.useEuiTheme)();
  const timerangeAsDays = (0, _react.useMemo)(() => (0, _metrics.getTimeRangeAsDays)({
    from,
    to
  }), [from, to]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: (0, _react2.css)`
        min-height: 140px;
        border: 1px solid ${colors.success};
      `,
    hasBorder: true,
    hasShadow: false,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_cost_savings_metric.CostSavingsMetric, {
    from: from,
    to: to,
    analystHourlyRate: analystHourlyRate,
    minutesPerAlert: minutesPerAlert,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_compare_percentage_badge.ComparePercentageBadge, {
    positionForLens: true,
    colorFamily: "bright",
    currentCount: costSavings,
    previousCount: costSavingsCompare,
    stat: (0, _metrics.formatDollars)(costSavingsCompare),
    statType: i18n.TIME_SAVED_DESC.toLowerCase(),
    timeRange: timerangeAsDays,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }));
};
exports.CostSavings = CostSavings;