"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComparePercentage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _utils = require("./utils");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/reports/components/ai_value/compare_percentage.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ComparePercentage = ({
  currentCount,
  previousCount,
  stat,
  statType,
  timeRange,
  positionForLens = false
}) => {
  const percentInfo = (0, _react.useMemo)(() => {
    return (0, _utils.getPercentInfo)({
      currentCount,
      previousCount,
      stat,
      statType
    });
  }, [currentCount, previousCount, stat, statType]);
  if (previousCount === 0 || currentCount === 0) {
    // do not display percentage change if either count is zero
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "comparePercentage",
    css: (0, _react2.css)`
        display: flex;
        flex-direction: column;
        z-index: 9999;
        position: relative;
        // positioning hack for Lens Metric
        top: ${positionForLens ? '-55px' : 'initial'};
        left: ${positionForLens ? '20px' : 'initial'};
        width: ${positionForLens ? '90%' : 'auto'};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, percentInfo.note, ` `, i18n.TIME_RANGE(timeRange), `.`));
};
exports.ComparePercentage = ComparePercentage;