"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatefulRecentTimelines = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _timeline = require("../../../../common/api/timeline");
var _all = require("../../../timelines/containers/all");
var _helpers = require("../../../timelines/components/open_timeline/helpers");
var _recent_timelines = require("./recent_timelines");
var i18n = _interopRequireWildcard(require("./translations"));
var _loading_placeholders = require("../loading_placeholders");
var _use_timeline_status = require("../../../timelines/components/open_timeline/use_timeline_status");
var _kibana = require("../../../common/lib/kibana");
var _types = require("../../../app/types");
var _constants = require("../../../../common/constants");
var _link_to = require("../../../common/components/link_to");
var _links = require("../../../common/components/links");
var _search_strategy = require("../../../../common/search_strategy");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/recent_timelines/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGE_SIZE = 3;
const StatefulRecentTimelinesComponent = ({
  filterBy
}) => {
  const {
    formatUrl
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.timelines);
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const queryTimelineById = (0, _helpers.useQueryTimelineById)();
  const onOpenTimeline = (0, _react.useCallback)(({
    duplicate,
    timelineId
  }) => {
    queryTimelineById({
      duplicate,
      timelineId
    });
  }, [queryTimelineById]);
  const goToTimelines = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.timelines
    });
  }, [navigateToApp]);
  const noTimelinesMessage = filterBy === 'favorites' ? i18n.NO_FAVORITE_TIMELINES : i18n.NO_TIMELINES;
  const linkAllTimelines = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
    onClick: goToTimelines,
    href: formatUrl(''),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, i18n.VIEW_ALL_TIMELINES), [goToTimelines, formatUrl]);
  const loadingPlaceholders = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_loading_placeholders.LoadingPlaceholders, {
    lines: 2,
    placeholders: filterBy === 'favorites' ? 1 : PAGE_SIZE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }), [filterBy]);
  const {
    fetchAllTimeline,
    timelines,
    loading
  } = (0, _all.useGetAllTimeline)();
  const timelineType = _timeline.TimelineTypeEnum.default;
  const {
    timelineStatus
  } = (0, _use_timeline_status.useTimelineStatus)({
    timelineType
  });
  (0, _react.useEffect)(() => {
    fetchAllTimeline({
      pageInfo: {
        pageIndex: 1,
        pageSize: PAGE_SIZE
      },
      search: '',
      sort: {
        sortField: _timeline.SortFieldTimelineEnum.updated,
        sortOrder: _search_strategy.Direction.desc
      },
      onlyUserFavorite: filterBy === 'favorites',
      status: timelineStatus,
      timelineType
    });
  }, [fetchAllTimeline, filterBy, timelineStatus, timelineType]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading ? loadingPlaceholders : /*#__PURE__*/_react.default.createElement(_recent_timelines.RecentTimelines, {
    noTimelinesMessage: noTimelinesMessage,
    onOpenTimeline: onOpenTimeline,
    timelines: timelines !== null && timelines !== void 0 ? timelines : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, linkAllTimelines));
};
StatefulRecentTimelinesComponent.displayName = 'StatefulRecentTimelinesComponent';
const StatefulRecentTimelines = exports.StatefulRecentTimelines = /*#__PURE__*/_react.default.memo(StatefulRecentTimelinesComponent);