"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkKnowledgeSourceComplete = void 0;
var _api = require("@kbn/elastic-assistant/impl/assistant/api/knowledge_base/api");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const checkKnowledgeSourceComplete = async ({
  http,
  notifications: {
    toasts
  }
}) => {
  var _ref;
  const kbStatus = await (0, _api.getKnowledgeBaseStatus)({
    http
  });
  if (kbStatus instanceof Error) {
    toasts.addError(kbStatus, {
      title: _translations.KNOWLEDGE_SOURCE_CARD_CHECK_COMPLETE_ERROR_MESSAGE
    });
    return {
      isComplete: false
    };
  }
  return {
    isComplete: (_ref = (kbStatus === null || kbStatus === void 0 ? void 0 : kbStatus.elser_exists) && (kbStatus === null || kbStatus === void 0 ? void 0 : kbStatus.security_labs_exists)) !== null && _ref !== void 0 ? _ref : false
  };
};
exports.checkKnowledgeSourceComplete = checkKnowledgeSourceComplete;