"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentRequiredCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _links = require("../../../../../../../common/components/links");
var _card_callout = require("../../card_callout");
var _kibana = require("../../../../../../../common/lib/kibana");
var _constants = require("../constants");
var _integration_context = require("../../../../../../../common/lib/integrations/hooks/integration_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/common/integrations/callouts/agent_required_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fleetAgentLinkProps = {
  appId: _constants.FLEET_APP_ID,
  path: _constants.ADD_AGENT_PATH
};
const AgentRequiredCallout = exports.AgentRequiredCallout = /*#__PURE__*/_react.default.memo(() => {
  const {
    getAppUrl,
    navigateTo
  } = (0, _kibana.useNavigation)();
  const addAgentLink = getAppUrl(fleetAgentLinkProps);
  const {
    telemetry: {
      reportLinkClick
    }
  } = (0, _integration_context.useIntegrationContext)();
  const onAddAgentClick = (0, _react.useCallback)(e => {
    e.preventDefault();
    reportLinkClick === null || reportLinkClick === void 0 ? void 0 : reportLinkClick(_constants.TELEMETRY_AGENT_REQUIRED);
    navigateTo(fleetAgentLinkProps);
  }, [navigateTo, reportLinkClick]);
  return /*#__PURE__*/_react.default.createElement(_card_callout.CardCallOut, {
    color: "warning",
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.onboarding.integrationsCard.callout.completeLabel",
      defaultMessage: `
      {desc} {link} {icon}
    `,
      values: {
        desc: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.onboarding.integrationsCard.agent.text",
          defaultMessage: "Elastic Agent is required for one or more of your integrations. Add Elastic Agent",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 46,
            columnNumber: 15
          }
        }),
        link: /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
          href: addAgentLink,
          onClick: onAddAgentClick,
          "data-test-subj": "agentLink",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 52,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.onboarding.integrationsCard.agent.link",
          defaultMessage: "here",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 53,
            columnNumber: 17
          }
        })),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "arrowRight",
          size: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 59,
            columnNumber: 19
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  });
});
AgentRequiredCallout.displayName = 'AgentRequiredCallout';