"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoteContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/notes/components/note_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OPEN_POPOVER = _i18n.i18n.translate('xpack.securitySolution.notes.expandRow.buttonLabel', {
  defaultMessage: 'Expand'
});
/**
 * Renders the note content to be displayed in the notes management table.
 * The content is truncated with an expand button to show the full content within the row.
 */
const NoteContent = exports.NoteContent = /*#__PURE__*/(0, _react.memo)(({
  note
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(value => !value), []);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    title: OPEN_POPOVER,
    "aria-label": OPEN_POPOVER,
    color: "text",
    flush: "left",
    onClick: togglePopover,
    "data-test-subj": _test_ids.NOTE_CONTENT_BUTTON_TEST_ID,
    css: (0, _react2.css)`
          height: ${euiTheme.size.l};
          white-space: nowrap;
          overflow: hidden;
          text-overflow: ellipsis;
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, note), [euiTheme.size.l, note, togglePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelStyle: {
      maxWidth: '50%',
      maxHeight: '50%',
      overflow: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    textSize: "s",
    "data-test-subj": _test_ids.NOTE_CONTENT_POPOVER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, note));
});
NoteContent.displayName = 'NoteContent';