"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _and_or_badge = require("../../../../../../common/components/and_or_badge");
var _condition_entry_input = require("../condition_entry_input");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/trusted_apps/view/components/condition_group/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConditionGroupFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  // The positioning of the 'and-badge' is done by using the EuiButton's height and adding on to it
  // the amount of padding used to space out each of the entries (times 2 because a spacer is also
  // used above the Button), and then we adjust it with 3px
  .and-badge {
    padding-top: 20px;
    padding-bottom: ${({
  theme
}) => {
  return `calc(${theme.eui.euiButtonHeightSmall} + (${theme.eui.euiSizeS} * 2) + 3px);`;
}};
  }

  .group-entries {
    margin-bottom: ${({
  theme
}) => theme.eui.euiSizeS};

    & > * {
      margin-bottom: ${({
  theme
}) => theme.eui.euiSizeS};

      &:last-child {
        margin-bottom: 0;
      }
    }
  }

  .and-button {
    min-width: 95px;
  }
`;
const ConditionGroup = exports.ConditionGroup = /*#__PURE__*/(0, _react.memo)(({
  os,
  entries,
  onEntryRemove,
  onEntryChange,
  onAndClicked,
  isAndDisabled,
  onVisited,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  return /*#__PURE__*/_react.default.createElement(ConditionGroupFlexGroup, {
    gutterSize: "xs",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, entries.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['xs', 's'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": getTestId('andConnector'),
    className: "and-badge",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    type: 'and',
    includeAntennas: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId('entries'),
    className: "group-entries",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, entries.map((entry, index) => /*#__PURE__*/_react.default.createElement(_condition_entry_input.ConditionEntryInput, {
    key: index,
    os: os,
    entry: entry,
    showLabels: index === 0,
    isRemoveDisabled: index === 0 && entries.length <= 1,
    onRemove: onEntryRemove,
    onChange: onEntryChange,
    onVisited: onVisited,
    "data-test-subj": getTestId(`entry${index}`),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    iconType: "plusInCircle",
    onClick: onAndClicked,
    "data-test-subj": getTestId('AndButton'),
    isDisabled: isAndDisabled,
    className: "and-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.trustedapps.logicalConditionBuilder.group.andOperator",
    defaultMessage: "AND",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  })))));
});
ConditionGroup.displayName = 'ConditionGroup';