"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectionUpdatesLayout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = require("styled-components");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _use_get_protection_updates_unavailable_component = require("./hooks/use_get_protection_updates_unavailable_component");
var _protection_updates_bottom_bar = require("./components/protection_updates_bottom_bar");
var _use_post_protection_updates_note = require("./hooks/use_post_protection_updates_note");
var _use_get_protection_updates_note = require("./hooks/use_get_protection_updates_note");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _kibana = require("../../../../../common/lib/kibana");
var _use_update_endpoint_policy = require("../../../../hooks/policy/use_update_endpoint_policy");
var _protection_updates_warning_panel = require("./components/protection_updates_warning_panel");
var _controlled_artifact_rollout = require("../../../../../../common/endpoint/utils/controlled_artifact_rollout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/protection_updates/protection_updates_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AUTOMATIC_UPDATES_CHECKBOX_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.useAutomaticUpdates', {
  defaultMessage: 'Automatic updates enabled'
});
const AUTOMATIC_UPDATES_OFF_CHECKBOX_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.useAutomaticUpdatesOff', {
  defaultMessage: 'Automatic updates disabled.'
});
const ProtectionUpdatesLayout = exports.ProtectionUpdatesLayout = /*#__PURE__*/_react.default.memo(({
  policy: _policy,
  setUnsavedChanges
}) => {
  const toasts = (0, _kibana.useToasts)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    isLoading: isUpdating,
    mutateAsync: sendPolicyUpdate
  } = (0, _use_update_endpoint_policy.useUpdateEndpointPolicy)();
  const {
    canWritePolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const paddingSize = (0, _react.useContext)(_styledComponents.ThemeContext).eui.euiPanelPaddingModifiers.paddingMedium;
  const policy = _policy;
  const deployedVersion = policy.inputs[0].config.policy.value.global_manifest_version;

  // Memoize date calculations to avoid midnight race conditions and ensure stability
  const {
    today,
    defaultDate,
    cutoffDate
  } = (0, _react.useMemo)(() => {
    const todayMoment = _moment.default.utc();
    const defaultDateMoment = todayMoment.clone().subtract(1, 'days');
    const cutoffDateMoment = (0, _controlled_artifact_rollout.getControlledArtifactCutoffDate)();
    return {
      today: todayMoment,
      defaultDate: defaultDateMoment,
      cutoffDate: cutoffDateMoment
    };
  }, []);
  const [selectedDate, setSelectedDate] = (0, _react.useState)(defaultDate);
  const {
    data: fetchedNote,
    isLoading: getNoteInProgress
  } = (0, _use_get_protection_updates_note.useGetProtectionUpdatesNote)({
    packagePolicyId: _policy.id
  });
  const {
    isLoading: createNoteInProgress,
    mutate: createNote
  } = (0, _use_post_protection_updates_note.useCreateProtectionUpdatesNote)({
    packagePolicyId: _policy.id
  });
  const [note, setNote] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (fetchedNote && !getNoteInProgress) {
      setNote(fetchedNote.note);
    }
  }, [fetchedNote, getNoteInProgress]);
  const internalDateFormat = 'YYYY-MM-DD';
  const displayDateFormat = 'MMMM DD, YYYY';
  const formattedDate = _moment.default.utc(deployedVersion, internalDateFormat).format(displayDateFormat);
  const [selectedManifestVersion, setSelectedManifestVersion] = (0, _react.useState)(deployedVersion === 'latest' ? 'latest' : selectedDate.format(internalDateFormat));
  const automaticUpdatesEnabled = selectedManifestVersion === 'latest';
  const viewModeSwitchLabel = automaticUpdatesEnabled ? AUTOMATIC_UPDATES_CHECKBOX_LABEL : AUTOMATIC_UPDATES_OFF_CHECKBOX_LABEL;
  const saveButtonEnabled = (fetchedNote ? note !== fetchedNote.note : note !== '') || selectedManifestVersion !== deployedVersion;
  (0, _react.useEffect)(() => {
    // Prevent unsaved changes modal from showing when the user has not made any changes
    if (selectedDate.isSame(defaultDate.toISOString(), 'day') && deployedVersion !== 'latest' && !automaticUpdatesEnabled && !_moment.default.utc(deployedVersion, internalDateFormat).isSame(selectedDate.toISOString(), 'days')) {
      return;
    }
    setUnsavedChanges(saveButtonEnabled);
  }, [automaticUpdatesEnabled, defaultDate, deployedVersion, saveButtonEnabled, selectedDate, setUnsavedChanges]);
  const onSave = (0, _react.useCallback)(() => {
    const update = (0, _lodash.cloneDeep)(policy);
    update.inputs[0].config.policy.value.global_manifest_version = selectedManifestVersion;
    sendPolicyUpdate({
      policy: update
    }).then(({
      item: policyItem
    }) => {
      toasts.addSuccess({
        'data-test-subj': 'protectionUpdatesSuccessfulMessage',
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.updateSuccessTitle', {
          defaultMessage: 'Success!'
        }),
        text: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.updateSuccessMessage', {
          defaultMessage: 'Manifest updates successfully saved'
        })
      });

      // Since the 'policyItem' is stored in a store and fetched as a result of an action on urlChange, we still need to dispatch an action even though Redux was removed from this component.
      dispatch({
        type: 'serverReturnedPolicyDetailsData',
        payload: {
          policyItem
        }
      });
    }).catch(err => {
      toasts.addDanger({
        'data-test-subj': 'protectionUpdatesFailureMessage',
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.updateErrorTitle', {
          defaultMessage: 'Failed!'
        }),
        text: err.message
      });
    });
    if (!fetchedNote && note !== '' || fetchedNote && note !== fetchedNote.note) {
      createNote({
        note
      }, {
        onError: error => {
          toasts.addDanger({
            'data-test-subj': 'protectionUpdatesNoteUpdateFailureMessage',
            title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.noteUpdateErrorTitle', {
              defaultMessage: 'Note update failed!'
            }),
            text: error.body.message
          });
        }
      });
    }
  }, [policy, selectedManifestVersion, sendPolicyUpdate, fetchedNote, note, toasts, dispatch, createNote]);
  const toggleAutomaticUpdates = (0, _react.useCallback)(event => {
    const {
      checked
    } = event.target;
    if (checked && !automaticUpdatesEnabled) {
      setSelectedManifestVersion('latest');
      // Clear selected date on user enabling automatic updates
      if (selectedDate !== defaultDate) {
        setSelectedDate(defaultDate);
      }
    } else {
      setSelectedManifestVersion(selectedDate.format(internalDateFormat));
    }
  }, [automaticUpdatesEnabled, selectedDate, defaultDate]);
  const updateDatepickerSelectedDate = (0, _react.useCallback)(date => {
    if (date !== null && date !== void 0 && date.startOf('day').isSameOrAfter(cutoffDate.clone().startOf('day')) && date !== null && date !== void 0 && date.isSameOrBefore(defaultDate)) {
      setSelectedDate(date || defaultDate);
      setSelectedManifestVersion((date === null || date === void 0 ? void 0 : date.format(internalDateFormat)) || 'latest');
    }
  }, [cutoffDate, defaultDate]);
  const renderVersionToDeployPicker = () => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      "data-test-subj": 'protection-updates-manifest-name-version-to-deploy-title',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.versionToDeploy.label', {
      defaultMessage: 'Version to deploy'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 11
      }
    }), canWritePolicyManagement ? /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": 'protection-updates-version-to-deploy-picker',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      popoverPlacement: 'downCenter',
      dateFormat: displayDateFormat,
      selected: selectedDate,
      maxDate: defaultDate,
      minDate: cutoffDate,
      onChange: updateDatepickerSelectedDate,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 15
      }
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      "data-test-subj": "protection-updates-version-to-deploy-view-mode",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 13
      }
    }, selectedDate.format(displayDateFormat)));
  };
  const renderManifestOutdatedCallOut = () => {
    if (automaticUpdatesEnabled || deployedVersion === 'latest') {
      return null;
    }
    const deployedVersionDate = _moment.default.utc(deployedVersion).format(internalDateFormat);
    const daysSinceLastUpdate = today.diff(deployedVersionDate, 'days');
    if (daysSinceLastUpdate < 30) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: 'warning',
      iconType: 'alert',
      size: "m",
      "data-test-subj": "protection-updates-manifest-outdated",
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.manifestOutdated.title', {
        defaultMessage: 'Manifest outdated'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.protectionUpdates.manifestOutdated",
      defaultMessage: "Your protection artifacts have not been updated in over 30 days. We strongly recommend keeping these up to date to ensure the highest level of security for your environment.{break}Note: After 18 months, protection artifacts will expire and cannot be rolled back. {learnMore}",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.securitySolution.artifactControl,
          target: "_blank",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 310,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.protectionUpdates.manifestOutdated.learnMore",
          defaultMessage: "Learn more",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 315,
            columnNumber: 21
          }
        })),
        break: /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 321,
            columnNumber: 24
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 11
      }
    }));
  };
  const renderContent = () => {
    if (automaticUpdatesEnabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: 'primary',
        iconType: 'info',
        size: "m",
        "data-test-subj": "protection-updates-automatic-updates-enabled",
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.automaticUpdates.enabledTitle', {
          defaultMessage: 'Automatic updates enabled'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 333,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.protectionUpdates.automaticUpdates.enabled",
        defaultMessage: "Protection updates will always be updated to the latest available version. If you want to control updates manually, disable the {toggleName} toggle.",
        values: {
          toggleName: /*#__PURE__*/_react.default.createElement("strong", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 350,
              columnNumber: 19
            }
          }, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.automaticUpdates.enabled.toggleName', {
            defaultMessage: 'Enable automatic updates'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 345,
          columnNumber: 13
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      "data-test-subj": 'protection-updates-manifest-name-deployed-version-title',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 370,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.deployedVersion.label', {
      defaultMessage: 'Currently deployed version'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 380,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      "data-test-subj": "protection-updates-deployed-version",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 381,
        columnNumber: 11
      }
    }, deployedVersion === 'latest' ? 'latest' : formattedDate), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 385,
        columnNumber: 11
      }
    }), renderVersionToDeployPicker(), (canWritePolicyManagement || note) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "none",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 390,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      "data-test-subj": 'protection-updates-manifest-name-note-title',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 392,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.note.label', {
      defaultMessage: 'Note'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.protectionUpdates.note.tooltip",
        defaultMessage: "You can add an optional note to explain the reason for selecting a particular policy version.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 405,
          columnNumber: 23
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 401,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 413,
        columnNumber: 15
      }
    }), canWritePolicyManagement ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      value: note,
      disabled: getNoteInProgress || createNoteInProgress,
      onChange: e => setNote(e.target.value),
      fullWidth: true,
      rows: 3,
      placeholder: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.note.placeholder', {
        defaultMessage: 'Add relevant information about update here'
      }),
      "data-test-subj": 'protection-updates-manifest-note',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 415,
        columnNumber: 17
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": 'protection-updates-manifest-note-view-mode',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 17
      }
    }, note)));
  };
  const ProtectionUpdatesUpsellingComponent = (0, _use_get_protection_updates_unavailable_component.useGetProtectionUpdatesUnavailableComponent)();
  if (ProtectionUpdatesUpsellingComponent) {
    return /*#__PURE__*/_react.default.createElement(ProtectionUpdatesUpsellingComponent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 443,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subject": "protection-updates-layout",
    hasBorder: true,
    hasShadow: false,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    alignItems: "center",
    style: {
      padding: `${paddingSize} ${paddingSize} 0 ${paddingSize}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 454,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 460,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": 'protection-updates-manifest-name-title',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 461,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.title', {
    defaultMessage: 'Manage protection updates'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['l', 'xl', 'm'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 13
    }
  }, canWritePolicyManagement ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: isUpdating || createNoteInProgress || getNoteInProgress,
    label: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.enableAutomaticUpdates', {
      defaultMessage: 'Enable automatic updates'
    }),
    labelProps: {
      'data-test-subj': 'protection-updates-manifest-switch-label'
    },
    checked: automaticUpdatesEnabled,
    onChange: toggleAutomaticUpdates,
    "data-test-subj": 'protection-updates-manifest-switch',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": 'protection-updates-state-view-mode',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 17
    }
  }, viewModeSwitchLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 492,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 493,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: `0 ${paddingSize} ${paddingSize} ${paddingSize}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 494,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_protection_updates_warning_panel.ProtectionUpdatesWarningPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 495,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 13
    }
  }), renderManifestOutdatedCallOut(), renderContent())), /*#__PURE__*/_react.default.createElement(_protection_updates_bottom_bar.ProtectionUpdatesBottomBar, {
    isUpdating: isUpdating,
    saveButtonDisabled: !canWritePolicyManagement || !saveButtonEnabled,
    onSave: onSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 501,
      columnNumber: 9
    }
  }));
});
ProtectionUpdatesLayout.displayName = 'ProtectionUpdatesLayout';