"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicySettingsForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _kibana = require("../../../../../common/lib/kibana");
var _update_antivirus_registration_enabled = require("../../../../../../common/endpoint/utils/update_antivirus_registration_enabled");
var _use_get_protections_unavailable_component = require("./hooks/use_get_protections_unavailable_component");
var _event_merging_banner = require("./components/event_merging_banner");
var _antivirus_registration_card = require("./components/cards/antivirus_registration_card");
var _linux_event_collection_card = require("./components/cards/linux_event_collection_card");
var _mac_event_collection_card = require("./components/cards/mac_event_collection_card");
var _windows_event_collection_card = require("./components/cards/windows_event_collection_card");
var _attack_surface_reduction_card = require("./components/cards/attack_surface_reduction_card");
var _behaviour_protection_card = require("./components/cards/protection_settings_card/behaviour_protection_card");
var _memory_protection_card = require("./components/cards/memory_protection_card");
var _related_detection_rules_callout = require("./components/related_detection_rules_callout");
var _ransomware_protection_card = require("./components/cards/ransomware_protection_card");
var _malware_protections_card = require("./components/cards/malware_protections_card");
var _advanced_section = require("./components/advanced_section");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _use_get_device_control_component = require("./hooks/use_get_device_control_component");
var _device_control_card = require("./components/cards/device_control_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/policy_settings_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PROTECTIONS_SECTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.protections', {
  defaultMessage: 'Protections'
});
const SETTINGS_SECTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.settings', {
  defaultMessage: 'Settings'
});
const PolicySettingsForm = exports.PolicySettingsForm = /*#__PURE__*/(0, _react.memo)(props => {
  var _storage$get;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(props['data-test-subj']);
  const ProtectionsUpSellingComponent = (0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const DeviceControlUpSellingComponent = (0, _use_get_device_control_component.useGetDeviceControlUpsellComponent)();
  const {
    storage
  } = (0, _kibana.useKibana)().services;
  const {
    eventCollectionDataReductionBannerEnabled,
    trustedDevices
  } = (0, _use_experimental_features.useEnableExperimental)();
  const renderDeviceControlSection = () => {
    if (!trustedDevices) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, DeviceControlUpSellingComponent ? /*#__PURE__*/_react.default.createElement(DeviceControlUpSellingComponent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_device_control_card.DeviceControlCard, (0, _extends2.default)({}, props, {
      "data-test-subj": getTestId('deviceControl'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 9
      }
    }));
  };
  const [showEventMergingBanner, setShowEventMergingBanner] = (0, _react.useState)(eventCollectionDataReductionBannerEnabled && ((_storage$get = storage.get('securitySolution.showEventMergingBanner')) !== null && _storage$get !== void 0 ? _storage$get : true));
  const onBannerDismiss = (0, _react.useCallback)(() => {
    setShowEventMergingBanner(false);
    storage.set('securitySolution.showEventMergingBanner', false);
  }, [storage]);
  const onChangeProxy = ({
    isValid,
    updatedPolicy
  }) => {
    // perform tasks that synchronises changes between settings
    (0, _update_antivirus_registration_enabled.updateAntivirusRegistrationEnabled)(updatedPolicy);
    props.onChange({
      isValid,
      updatedPolicy
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, showEventMergingBanner && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_event_merging_banner.EventMergingBanner, {
    onDismiss: onBannerDismiss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(FormSectionTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, PROTECTIONS_SECTION_TITLE), ProtectionsUpSellingComponent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(ProtectionsUpSellingComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  })), !ProtectionsUpSellingComponent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_related_detection_rules_callout.RelatedDetectionRulesCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_malware_protections_card.MalwareProtectionsCard, (0, _extends2.default)({}, props, {
    onChange: onChangeProxy,
    "data-test-subj": getTestId('malware'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_ransomware_protection_card.RansomwareProtectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('ransomware'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_memory_protection_card.MemoryProtectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('memory'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_behaviour_protection_card.BehaviourProtectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('behaviour'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_attack_surface_reduction_card.AttackSurfaceReductionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('attackSurface'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }), renderDeviceControlSection()), /*#__PURE__*/_react.default.createElement(FormSectionTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, SETTINGS_SECTION_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_windows_event_collection_card.WindowsEventCollectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('windowsEvents'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_mac_event_collection_card.MacEventCollectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('macEvents'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_linux_event_collection_card.LinuxEventCollectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('linuxEvents'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_antivirus_registration_card.AntivirusRegistrationCard, (0, _extends2.default)({}, props, {
    onChange: onChangeProxy,
    "data-test-subj": getTestId('antivirusRegistration'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_advanced_section.AdvancedSection, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('advancedSection'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  })));
});
PolicySettingsForm.displayName = 'PolicySettingsForm';
const FormSectionTitle = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, children));
});
FormSectionTitle.displayName = 'FormSectionTitle';