"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AntivirusRegistrationCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _update_antivirus_registration_enabled = require("../../../../../../../../common/endpoint/utils/update_antivirus_registration_enabled");
var _types = require("../../../../../../../../common/endpoint/types");
var _use_get_protections_unavailable_component = require("../../hooks/use_get_protections_unavailable_component");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
var _setting_card = require("../setting_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/cards/antivirus_registration_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.type', {
  defaultMessage: 'Register as antivirus'
});
const DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.explanation', {
  defaultMessage: 'Enable to register Elastic as an official Antivirus solution for Windows OS. ' + 'This will also disable Windows Defender.'
});
const ENABLED = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.syncWithMalwarePrevent.enabled', {
  defaultMessage: 'enabled'
});
const DISABLED = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.syncWithMalwarePrevent.disabled', {
  defaultMessage: 'disabled'
});
const AntivirusRegistrationCard = exports.AntivirusRegistrationCard = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  mode,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isProtectionsAllowed = !(0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const isEditMode = mode === 'edit';
  const currentMode = policy.windows.antivirus_registration.mode;
  const labels = (0, _react.useMemo)(() => ({
    [_types.AntivirusRegistrationModes.disabled]: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.disabled', {
      defaultMessage: 'Disabled'
    }),
    [_types.AntivirusRegistrationModes.enabled]: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.enabled', {
      defaultMessage: 'Enabled'
    }),
    [_types.AntivirusRegistrationModes.sync]: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.syncWithMalwarePrevent', {
      defaultMessage: 'Sync with malware protection level'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.syncWithMalwarePrevent.tooltip', {
        defaultMessage: 'Use this setting to automatically enable antivirus registration if malware protection is set to Prevent. ' + 'In any other case, antivirus registration will be disabled.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: isEditMode ? 'subdued' : undefined,
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.antivirusRegistration.syncWithMalwarePrevent.currentOutcome', {
      defaultMessage: '(Current level: {currentOutcome})',
      values: {
        currentOutcome: (0, _update_antivirus_registration_enabled.shouldEnableAntivirusRegistrationForSync)(policy) ? ENABLED : DISABLED
      }
    })))
  }), [isEditMode, policy]);
  const handleChange = event => {
    const updatedPolicy = (0, _lodash.cloneDeep)(policy);
    updatedPolicy.windows.antivirus_registration.mode = event.target.value;
    onChange({
      isValid: true,
      updatedPolicy
    });
  };
  if (!isProtectionsAllowed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: CARD_TITLE,
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS],
    dataTestSubj: getTestId(),
    osRestriction: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.av.windowsServerNotSupported', {
      defaultMessage: 'Windows Server operating systems unsupported because Antivirus registration requires Windows Security Center, which is not included in Windows Server operating systems.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, isEditMode && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 24
    }
  }, DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": getTestId('radioButtons'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, Object.values(_types.AntivirusRegistrationModes).map(registrationMode => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: registrationMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    name: "antivirus-registration",
    id: registrationMode,
    value: registrationMode,
    onChange: handleChange,
    label: labels[registrationMode],
    checked: currentMode === registrationMode,
    disabled: !isEditMode,
    "data-test-subj": getTestId(registrationMode),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  })))));
});
AntivirusRegistrationCard.displayName = 'AntivirusRegistrationCard';