"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointEventCollectionPreset = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _help_text_with_padding = require("./help_text_with_padding");
var _translations = require("../translations");
var _use_get_protections_unavailable_component = require("../../../policy_settings_form/hooks/use_get_protections_unavailable_component");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/endpoint_policy_create_extension/components/endpoint_event_collection_preset.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NOOP = () => {};
/**
 * Display ONLY the event collection option on the screen along with the upselling message
 */
const EndpointEventCollectionPreset = exports.EndpointEventCollectionPreset = /*#__PURE__*/(0, _react.memo)(({
  onChange,
  newPolicy
}) => {
  const UpsellToIncludePolicyProtections = (0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const preset = 'DataCollection';
  const policyInputs = (0, _react.useMemo)(() => {
    return [{
      enabled: true,
      streams: [],
      type: _constants.ENDPOINT_INTEGRATION_CONFIG_KEY,
      config: {
        _config: {
          value: {
            type: 'endpoint',
            endpointConfig: {
              preset
            }
          }
        }
      }
    }];
  }, []);
  (0, _react.useEffect)(() => {
    var _inputs$, _inputs$$config;
    const inputs = newPolicy.inputs;
    if (inputs.length === 0) {
      onChange({
        isValid: false,
        updatedPolicy: {
          ...newPolicy,
          name: '',
          inputs: policyInputs
        }
      });
      return;
    }
    if (((_inputs$ = inputs[0]) === null || _inputs$ === void 0 ? void 0 : (_inputs$$config = _inputs$.config) === null || _inputs$$config === void 0 ? void 0 : _inputs$$config._config.value.endpointConfig.preset) !== preset) {
      onChange({
        isValid: true,
        updatedPolicy: {
          ...newPolicy,
          inputs: policyInputs
        }
      });
    }
  }, [newPolicy, onChange, policyInputs]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "endpointDataCollectionOnlyPreset",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_help_text_with_padding.HelpTextWithPadding, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 21
      }
    }, _translations.DATA_COLLECTION_HELP_TEXT),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    name: "endpointDataCollection",
    id: "endpoint_data_collection_only_preset",
    onChange: NOOP,
    disabled: true,
    checked: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, _translations.DATA_COLLECTION))), UpsellToIncludePolicyProtections && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(UpsellToIncludePolicyProtections, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  })));
});
EndpointEventCollectionPreset.displayName = 'EndpointEventCollectionPreset';