"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRUSTED_DEVICES_LABELS = exports.TRUSTED_APPS_LABELS = exports.HOST_ISOLATION_EXCEPTIONS_LABELS = exports.EVENT_FILTERS_LABELS = exports.BLOCKLISTS_LABELS = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/endpoint_package_custom_extension/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TRUSTED_APPS_LABELS = exports.TRUSTED_APPS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.trustedAppsSummary.error', {
    defaultMessage: 'There was an error trying to fetch trusted applications stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.trustedApps.fleetIntegration.title",
    defaultMessage: "Trusted applications",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  })
};
const TRUSTED_DEVICES_LABELS = exports.TRUSTED_DEVICES_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.trustedDevicesSummary.error', {
    defaultMessage: 'There was an error trying to fetch trusted devices stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.trustedDevices.fleetIntegration.title",
    defaultMessage: "Trusted devices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  })
};
const EVENT_FILTERS_LABELS = exports.EVENT_FILTERS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.eventFiltersSummary.error', {
    defaultMessage: 'There was an error trying to fetch event filters stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.eventFilters.fleetIntegration.title",
    defaultMessage: "Event filters",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  })
};
const HOST_ISOLATION_EXCEPTIONS_LABELS = exports.HOST_ISOLATION_EXCEPTIONS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.hostIsolationExceptionsSummary.error', {
    defaultMessage: 'There was an error trying to fetch host isolation exceptions stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.hostIsolationExceptions.fleetIntegration.title",
    defaultMessage: "Host isolation exceptions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  })
};
const BLOCKLISTS_LABELS = exports.BLOCKLISTS_LABELS = {
  artifactsSummaryApiError: error => _i18n.i18n.translate('xpack.securitySolution.endpoint.fleetCustomExtension.blocklistsSummary.error', {
    defaultMessage: 'There was an error trying to fetch blocklist stats: "{error}"',
    values: {
      error
    }
  }),
  cardTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.blocklists.fleetIntegration.title",
    defaultMessage: "Blocklist",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  })
};