"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.testIdPrefix = exports.HostIsolationExceptionsForm = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
var _is_valid_ip = require("../../../../../../common/endpoint/utils/is_valid_ip");
var _effected_policy_select = require("../../../../components/effected_policy_select");
var _translations = require("./translations");
var _formatted_error = require("../../../../components/formatted_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/host_isolation_exceptions/view/components/form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const testIdPrefix = exports.testIdPrefix = 'hostIsolationExceptions-form';
const HostIsolationExceptionsForm = exports.HostIsolationExceptionsForm = /*#__PURE__*/(0, _react.memo)(({
  item: exception,
  onChange,
  disabled,
  mode,
  error
}) => {
  var _exception$os_types2;
  const ipEntry = (0, _react.useMemo)(() => {
    return exception.entries[0] || {
      field: 'destination.ip',
      operator: 'included',
      type: 'match',
      value: ''
    };
  }, [exception.entries]);
  const [hasBeenInputNameVisited, setHasBeenInputNameVisited] = (0, _react.useState)(false);
  const [hasBeenInputIpVisited, setHasBeenInputIpVisited] = (0, _react.useState)(false);
  const [hasNameError, setHasNameError] = (0, _react.useState)(!exception.name);
  const [hasIpError, setHasIpError] = (0, _react.useState)(!ipEntry.value);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(testIdPrefix);
  const isFormContentValid = (0, _react.useMemo)(() => {
    return !hasNameError && !hasIpError;
  }, [hasIpError, hasNameError]);
  const notifyOfChange = (0, _react.useCallback)(updatedItem => {
    onChange({
      item: updatedItem ? {
        ...exception,
        ...updatedItem
      } : exception,
      isValid: isFormContentValid
    });
  }, [exception, isFormContentValid, onChange]);
  const handleOnChangeName = (0, _react.useCallback)(event => {
    const name = event.target.value;
    if (!name.trim()) {
      setHasNameError(true);
    } else {
      setHasNameError(false);
    }
    notifyOfChange({
      name
    });
  }, [notifyOfChange]);
  const handleOnIpChange = (0, _react.useCallback)(event => {
    const ip = event.target.value;
    if (!(0, _is_valid_ip.isValidIPv4OrCIDR)(ip)) {
      setHasIpError(true);
    } else {
      setHasIpError(false);
    }
    notifyOfChange({
      entries: [{
        ...ipEntry,
        value: ip
      }]
    });
  }, [ipEntry, notifyOfChange]);
  const handleEffectedPolicyOnChange = (0, _react.useCallback)(updatedItem => {
    notifyOfChange(updatedItem);
  }, [notifyOfChange]);
  const handleOnDescriptionChange = (0, _react.useCallback)(event => {
    notifyOfChange({
      description: event.target.value
    });
  }, [notifyOfChange]);
  const nameInput = (0, _react.useMemo)(() => {
    var _exception$name;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _translations.NAME_LABEL,
      fullWidth: true,
      isInvalid: hasNameError && hasBeenInputNameVisited,
      error: _translations.NAME_ERROR,
      isDisabled: disabled,
      "data-test-subj": "hostIsolationExceptions-form-name-input-formRow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: hasNameError && hasBeenInputNameVisited,
      id: "eventFiltersFormInputName",
      placeholder: _translations.NAME_PLACEHOLDER,
      defaultValue: (_exception$name = exception.name) !== null && _exception$name !== void 0 ? _exception$name : '',
      onChange: handleOnChangeName,
      fullWidth: true,
      "aria-label": _translations.NAME_PLACEHOLDER,
      required: hasBeenInputNameVisited,
      maxLength: 256,
      "data-test-subj": "hostIsolationExceptions-form-name-input",
      onBlur: () => !hasBeenInputNameVisited && setHasBeenInputNameVisited(true),
      disabled: disabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 11
      }
    }));
  }, [disabled, exception.name, handleOnChangeName, hasBeenInputNameVisited, hasNameError]);
  const ipInput = (0, _react.useMemo)(() => {
    var _value, _exception$entries, _exception$entries$;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _translations.IP_LABEL,
      fullWidth: true,
      isInvalid: hasIpError && hasBeenInputIpVisited,
      error: _translations.IP_ERROR,
      isDisabled: disabled,
      "data-test-subj": "hostIsolationExceptions-form-ip-input-formRow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: hasIpError && hasBeenInputIpVisited,
      id: "eventFiltersFormInputName",
      placeholder: _translations.IP_PLACEHOLDER,
      defaultValue: (_value = (_exception$entries = exception.entries) === null || _exception$entries === void 0 ? void 0 : (_exception$entries$ = _exception$entries[0]) === null || _exception$entries$ === void 0 ? void 0 : _exception$entries$.value) !== null && _value !== void 0 ? _value : '',
      onChange: handleOnIpChange,
      fullWidth: true,
      "aria-label": _translations.IP_PLACEHOLDER,
      required: hasBeenInputIpVisited,
      maxLength: 256,
      "data-test-subj": "hostIsolationExceptions-form-ip-input",
      onBlur: () => !hasBeenInputIpVisited && setHasBeenInputIpVisited(true),
      disabled: disabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 11
      }
    }));
  }, [disabled, exception.entries, handleOnIpChange, hasBeenInputIpVisited, hasIpError]);
  const descriptionInput = (0, _react.useMemo)(() => {
    var _exception$descriptio;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _translations.DESCRIPTION_LABEL,
      fullWidth: true,
      isDisabled: disabled,
      "data-test-subj": "hostIsolationExceptions-form-description-input-formRow",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      id: "eventFiltersFormInputName",
      placeholder: _translations.DESCRIPTION_PLACEHOLDER,
      defaultValue: (_exception$descriptio = exception.description) !== null && _exception$descriptio !== void 0 ? _exception$descriptio : '',
      onChange: handleOnDescriptionChange,
      fullWidth: true,
      "data-test-subj": "hostIsolationExceptions-form-description-input",
      "aria-label": _translations.DESCRIPTION_PLACEHOLDER,
      maxLength: 256,
      disabled: disabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 11
      }
    }));
  }, [disabled, exception.description, handleOnDescriptionChange]);

  // Anytime the `notificyOfChange()` is re-defined, call it with current values.
  // This will happen
  (0, _react.useEffect)(() => {
    notifyOfChange(); // << Important to call it with no arguments, so that existing values are sent
  }, [notifyOfChange]);

  // Make sure in the create flow, the OS array is set to the 3 OSs supported
  (0, _react.useEffect)(() => {
    var _exception$os_types$l, _exception$os_types;
    if (mode === 'create' && ((_exception$os_types$l = (_exception$os_types = exception.os_types) === null || _exception$os_types === void 0 ? void 0 : _exception$os_types.length) !== null && _exception$os_types$l !== void 0 ? _exception$os_types$l : 0) !== 3) {
      notifyOfChange({
        os_types: ['windows', 'linux', 'macos']
      });
    }
  }, [(_exception$os_types2 = exception.os_types) === null || _exception$os_types2 === void 0 ? void 0 : _exception$os_types2.length, mode, notifyOfChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "div",
    error: error && /*#__PURE__*/_react.default.createElement(_formatted_error.FormattedError, {
      error: error,
      "data-test-subj": 'hostIsolationExceptions-form-submitError',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 13
      }
    }),
    isInvalid: !!error,
    "data-test-subj": "hostIsolationExceptions-form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.hostIsolationExceptions.form.title",
    defaultMessage: "Details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.hostIsolationExceptions.form.description",
    defaultMessage: "Allows isolated hosts to connect to these IP addresses. Only accepts IPv4 with optional CIDR.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }), nameInput, descriptionInput, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.hostIsolationExceptions.form.conditions.title",
    defaultMessage: "Conditions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.hostIsolationExceptions.form.conditions.subtitle",
    defaultMessage: "Host Isolation exceptions will apply to all operating systems.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 9
    }
  }), ipInput, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": 'effectedPolicies-container',
    isDisabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_effected_policy_select.EffectedPolicySelect, {
    item: exception,
    onChange: handleEffectedPolicyOnChange,
    "data-test-subj": getTestId('effectedPolicies'),
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 11
    }
  })));
});
HostIsolationExceptionsForm.displayName = 'HostIsolationExceptionsForm';