"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkflowInsightsResults = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _constants = require("../../../../constants");
var _translations = require("../../../translations");
var _incompatible_antivirus = require("./results/incompatible_antivirus");
var _policy_response_failure = require("./results/policy_response_failure");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/details/components/insights/workflow_insights_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CustomEuiCallOut = (0, _styledComponents.default)(_eui.EuiCallOut)`
  & .euiButtonIcon {
    margin-top: 5px; /* Lower the close button */
  }
`;
const ScrollableContainer = (0, _styledComponents.default)(_eui.EuiPanel)`
  max-height: 500px;
  overflow-y: auto;
  padding: 0;
`;
const WorkflowInsightsResults = ({
  results,
  scanCompleted,
  endpointId
}) => {
  const [showEmptyResultsCallout, setShowEmptyResultsCallout] = (0, _react.useState)(false);
  const hideEmptyStateCallout = () => setShowEmptyResultsCallout(false);
  (0, _react.useEffect)(() => {
    setShowEmptyResultsCallout((results === null || results === void 0 ? void 0 : results.length) === 0 && scanCompleted);
  }, [results, scanCompleted]);
  const insights = (0, _react.useMemo)(() => {
    if (showEmptyResultsCallout) {
      return /*#__PURE__*/_react.default.createElement(CustomEuiCallOut, {
        onDismiss: hideEmptyStateCallout,
        color: 'success',
        "data-test-subj": 'workflowInsightsEmptyResultsCallout',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 9
        }
      }, _translations.WORKFLOW_INSIGHTS.issues.emptyResults);
    } else if (results !== null && results !== void 0 && results.length) {
      return results.flatMap((insight, index) => {
        switch (insight.type) {
          case _elasticAssistantCommon.DefendInsightType.Enum.incompatible_antivirus:
            return /*#__PURE__*/_react.default.createElement(_incompatible_antivirus.WorkflowInsightsIncompatibleAntivirusResult, {
              insight: insight,
              index: index,
              endpointId: endpointId,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 74,
                columnNumber: 15
              }
            });
          case _elasticAssistantCommon.DefendInsightType.Enum.policy_response_failure:
            return /*#__PURE__*/_react.default.createElement(_policy_response_failure.WorkflowInsightsPolicyResponseFailureResult, {
              insight: insight,
              index: index,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 81,
                columnNumber: 20
              }
            });
          default:
            return null;
        }
      });
    }
    return null;
  }, [endpointId, results, showEmptyResultsCallout]);
  const surveyLink = (0, _react.useMemo)(() => {
    if (!(results !== null && results !== void 0 && results.length)) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'xs',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 'xs',
      alignItems: 'center',
      "data-test-subj": 'workflowInsightsSurveySection',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "discuss",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: 'xs',
      "data-test-subj": 'workflowInsightsSurveyLink',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }, _translations.WORKFLOW_INSIGHTS.issues.survey.description, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: _constants.WORKFLOW_INSIGHTS_SURVEY_URL,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 15
      }
    }, _translations.WORKFLOW_INSIGHTS.issues.survey.callToAction)))));
  }, [results]);
  const showInsights = !!(showEmptyResultsCallout || results !== null && results !== void 0 && results.length);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showInsights && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, _translations.WORKFLOW_INSIGHTS.issues.title)), surveyLink, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 's',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(ScrollableContainer, {
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, insights)), showInsights && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 24
    }
  }));
};
exports.WorkflowInsightsResults = WorkflowInsightsResults;