"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Blocklist = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../common/components/user_privileges");
var _kibana = require("../../../../common/lib/kibana");
var _artifact_list_page = require("../../../components/artifact_list_page");
var _services = require("../services");
var _blocklist_form = require("./components/blocklist_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/blocklist/view/blocklist.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BLOCKLIST_PAGE_LABELS = {
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.blocklist.pageTitle', {
    defaultMessage: 'Blocklist'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.blocklist.pageAboutInfo', {
    defaultMessage: 'The blocklist prevents selected applications from running on your hosts by extending the list of processes the Endpoint considers malicious.'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.blocklist.pageAddButtonTitle', {
    defaultMessage: 'Add blocklist entry'
  }),
  getShowingCountLabel: total => _i18n.i18n.translate('xpack.securitySolution.blocklist.showingTotal', {
    defaultMessage: 'Showing {total} {total, plural, one {blocklist entry} other {blocklist entries}}',
    values: {
      total
    }
  }),
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.blocklist.cardActionEditLabel', {
    defaultMessage: 'Edit blocklist'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.blocklist.cardActionDeleteLabel', {
    defaultMessage: 'Delete blocklist'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.blocklist.flyoutCreateTitle', {
    defaultMessage: 'Add blocklist'
  }),
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.blocklist.flyoutEditTitle', {
    defaultMessage: 'Edit blocklist'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.blocklist.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add blocklist'
  }),
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.blocklist.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added to your blocklist.',
    values: {
      name
    }
  }),
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.blocklist.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  }),
  flyoutDowngradedLicenseDocsInfo: securitySolutionDocsLinks => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.blocklist.flyoutDowngradedLicenseDocsInfo",
      defaultMessage: "For more information, see our ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: `${securitySolutionDocsLinks.blocklist}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.blocklist.flyoutDowngradedLicenseDocsLink",
      defaultMessage: "blocklist documentation.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 11
      }
    })));
  },
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.blocklist.deleteSuccess', {
    defaultMessage: '"{itemName}" has been removed from blocklist.',
    values: {
      itemName
    }
  }),
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.blocklist.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no blocklist entries to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.blocklist.emptyStateTitle', {
    defaultMessage: 'Add your first blocklist entry'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.blocklist.emptyStateInfo', {
    defaultMessage: 'The blocklist prevents specified applications from running on your hosts, extending the list of processes that Endpoint Security considers malicious.'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.blocklist.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add blocklist entry'
  }),
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.blocklist.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, value'
  })
};
const Blocklist = exports.Blocklist = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    canWriteBlocklist
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const http = (0, _kibana.useHttp)();
  const blocklistsApiClient = _services.BlocklistsApiClient.getInstance(http);
  return /*#__PURE__*/_react.default.createElement(_artifact_list_page.ArtifactListPage, {
    apiClient: blocklistsApiClient,
    ArtifactFormComponent: _blocklist_form.BlockListForm,
    labels: BLOCKLIST_PAGE_LABELS,
    "data-test-subj": "blocklistPage",
    flyoutSize: "l",
    allowCardCreateAction: canWriteBlocklist,
    allowCardEditAction: canWriteBlocklist,
    allowCardDeleteAction: canWriteBlocklist,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  });
});
Blocklist.displayName = 'Blocklist';