"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsLogUsersFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _translations = require("../translations");
var _use_action_history_url_params = require("./use_action_history_url_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_response_actions_list/components/actions_log_users_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionsLogUsersFilter = exports.ActionsLogUsersFilter = /*#__PURE__*/(0, _react.memo)(({
  isFlyout,
  onChangeUsersFilter,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const {
    users: usersFromUrlParams,
    setUrlUsersFilters
  } = (0, _use_action_history_url_params.useActionHistoryUrlParams)();
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const onChange = (0, _react.useCallback)(e => {
    const {
      value
    } = e.target;
    setSearchValue(e.target.value);
    if (!value) {
      onChangeUsersFilter([]);
      if (!isFlyout) {
        setUrlUsersFilters('');
      }
    }
  }, [setSearchValue, isFlyout, setUrlUsersFilters, onChangeUsersFilter]);
  const onSearch = (0, _react.useCallback)(onSearchValue => {
    if (!onSearchValue) return;
    const userIds = searchValue.split(',').reduce((acc, curr) => {
      if (curr.trim() !== '') {
        acc.push(curr.trim());
      }
      return acc;
    }, []);
    onChangeUsersFilter(userIds);
    if (!isFlyout) {
      setUrlUsersFilters(userIds.join(','));
    }
  }, [isFlyout, onChangeUsersFilter, searchValue, setUrlUsersFilters]);

  // on load with users in urlParams, set the search value
  (0, _react.useEffect)(() => {
    if (usersFromUrlParams && usersFromUrlParams.length > 0) {
      setSearchValue(usersFromUrlParams.join(','));
    }
    // do this only once on load
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": getTestId('users-filter-search'),
    isClearable: true,
    fullWidth: true,
    placeholder: _translations.FILTER_NAMES.users,
    onChange: onChange,
    onSearch: onSearch,
    value: searchValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  });
});
ActionsLogUsersFilter.displayName = 'ActionsLogUsersFilter';