"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Console = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _console_footer = require("./components/console_footer");
var _console_header = require("./components/console_header");
var _command_input = require("./components/command_input");
var _console_state = require("./components/console_state");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _console_manager = require("./components/console_manager/console_manager");
var _history_output = require("./components/history_output");
var _side_panel_flex_item = require("./components/side_panel/side_panel_flex_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/console.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConsoleWindow = _styledComponents.default.div`
  height: 100%;
  background-color: ${({
  theme: {
    eui
  }
}) => eui.euiPageBackgroundColor};
  border: ${({
  theme: {
    eui
  }
}) => eui.euiBorderThin};
  border-radius: ${({
  theme: {
    eui
  }
}) => eui.euiBorderRadiusSmall};

  .layout {
    height: 100%;
    width: 100%;
    min-height: 300px;
    min-width: 300px;
    overflow: hidden;

    &-hideOverflow {
      overflow: hidden;
    }

    &-bottomBorder {
      border-bottom: ${({
  theme: {
    eui
  }
}) => eui.euiSizeS} solid
        ${({
  theme: {
    eui
  }
}) => eui.euiPageBackgroundColor};
    }

    &-container {
      padding: ${({
  theme: {
    eui
  }
}) => eui.euiPanelPaddingModifiers.paddingMedium};
    }

    &-header {
      background-color: ${({
  theme: {
    eui
  }
}) => eui.euiColorEmptyShade};
      border-bottom: 1px solid ${({
  theme: {
    eui
  }
}) => eui.euiColorLightShade};
      border-top-left-radius: ${({
  theme: {
    eui
  }
}) => eui.euiBorderRadiusSmall};
      border-top-right-radius: ${({
  theme: {
    eui
  }
}) => eui.euiBorderRadiusSmall};
      padding: ${({
  theme: {
    eui
  }
}) => eui.euiSize} ${({
  theme: {
    eui
  }
}) => eui.euiSize}
        ${({
  theme: {
    eui
  }
}) => eui.euiSize} ${({
  theme: {
    eui
  }
}) => eui.euiSize};
    }

    &-commandInput {
      padding-top: ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS};
      padding-bottom: ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS};
    }

    &-footer {
      padding-top: 0;
      padding-bottom: ${({
  theme: {
    eui
  }
}) => eui.euiSizeXS};
    }

    &-rightPanel {
      width: 35%;
      background-color: ${({
  theme: {
    eui
  }
}) => eui.euiFormBackgroundColor};
      border-left: ${({
  theme: {
    eui
  }
}) => eui.euiBorderThin};
    }

    &-historyOutput {
      overflow: auto;
    }

    &-historyViewport {
      height: 100%;
      overflow-x: hidden;
      white-space: pre-wrap;
    }

    // min-width setting is needed for flex items to ensure that overflow works as expected
    // in the Input area and not cause the entire UI to expand beyond the overall width of
    // the console. @see https://css-tricks.com/flexbox-truncated-text
    // To prevent this from being applied to an individual flex item, use the classname of
    // 'noMinWidth'. For areas of the Console that render components external to the Console,
    // use className 'noThemeOverrides' to prevent this from impacting those components/
    .euiFlexItem:not(.noMinWidth):not(.noThemeOverrides .euiFlexItem) {
      min-width: 0;
    }
  }

  //-----------------------------------------------------------
  // 👇 Utility classnames for use anywhere inside of Console
  //-----------------------------------------------------------

  .font-family-code {
    font-family: ${({
  theme: {
    eui
  }
}) => eui.euiCodeFontFamily};
  }

  .font-style-italic {
    font-style: italic;
  }
`;
const Console = exports.Console = /*#__PURE__*/(0, _react.memo)(({
  prompt,
  commands,
  HelpComponent,
  TitleComponent,
  storagePrefix,
  managedKey,
  ...commonProps
}) => {
  const scrollingViewport = (0, _react.useRef)(null);
  const inputFocusRef = (0, _react.useRef)(null);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(commonProps['data-test-subj']);
  const managedConsole = (0, _console_manager.useWithManagedConsole)(managedKey);
  const scrollToBottom = (0, _react.useCallback)(() => {
    // We need the `setTimeout` here because in some cases, the command output
    // will take a bit of time to populate its content due to the use of Promises
    setTimeout(() => {
      if (scrollingViewport.current) {
        scrollingViewport.current.scrollTop = scrollingViewport.current.scrollHeight;
      }
    }, 1);

    // NOTE: its IMPORTANT that this callback does NOT have any dependencies, because
    // it is stored in State and currently not updated if it changes
  }, []);
  const setFocusOnInput = (0, _react.useCallback)(() => {
    if (inputFocusRef.current) {
      inputFocusRef.current.focus();
    }
  }, []);

  // When the console is shown, set focus to it so that user can just start typing
  (0, _react.useEffect)(() => {
    if (!managedConsole || managedConsole.isOpen) {
      setTimeout(setFocusOnInput, 2);
    }
  }, [setFocusOnInput, managedConsole]);
  return /*#__PURE__*/_react.default.createElement(_console_state.ConsoleStateProvider, {
    commands: commands,
    scrollToBottom: scrollToBottom,
    keyCapture: inputFocusRef,
    managedKey: managedKey,
    HelpComponent: HelpComponent,
    dataTestSubj: commonProps['data-test-subj'],
    storagePrefix: storagePrefix,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(ConsoleWindow, (0, _extends2.default)({}, commonProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "layout",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    className: "layout",
    gutterSize: "none",
    responsive: false,
    "data-test-subj": getTestId('mainPanel'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "layout-header",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_console_header.ConsoleHeader, {
    TitleComponent: TitleComponent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: "layout-hideOverflow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    className: "layout-hideOverflow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-fullHeight layout-hideOverflow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false,
    className: "layout-hideOverflow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: "layout-historyOutput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "layout-container layout-historyViewport eui-scrollBar eui-yScroll",
    ref: scrollingViewport,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_history_output.HistoryOutput, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 29
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    onClick: setFocusOnInput,
    grow: false,
    className: "layout-container layout-commandInput",
    "data-test-subj": getTestId('mainPanel-inputArea'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_command_input.CommandInput, {
    prompt: prompt,
    focusRef: inputFocusRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "layout-container layout-footer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_console_footer.ConsoleFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 27
    }
  })))))))), /*#__PURE__*/_react.default.createElement(_side_panel_flex_item.SidePanelFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 14
    }
  }))));
});
Console.displayName = 'Console';