"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsFlyoutOpened = void 0;
var _react = require("react");
var _use_url_params = require("../../../hooks/use_url_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SHOW_VALUES = ['create', 'edit'];
const useIsFlyoutOpened = (allowEdit = true, allowCreate = true) => {
  var _useUrlParams$urlPara;
  const showUrlParamValue = (_useUrlParams$urlPara = (0, _use_url_params.useUrlParams)().urlParams.show) !== null && _useUrlParams$urlPara !== void 0 ? _useUrlParams$urlPara : '';
  return (0, _react.useMemo)(() => {
    if (SHOW_VALUES.includes(showUrlParamValue)) {
      return showUrlParamValue === 'create' && allowCreate || showUrlParamValue === 'edit' && allowEdit;
    }
    return false;
  }, [allowCreate, allowEdit, showUrlParamValue]);
};
exports.useIsFlyoutOpened = useIsFlyoutOpened;