"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TakeAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_investigate_in_timeline = require("../../../../common/hooks/timeline/use_investigate_in_timeline");
var _normalize_time_range = require("../../../../common/utils/normalize_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/shared/components/take_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * This component is used to investigate a host|user|entity using Timeline from Flyout
 */
const TakeAction = ({
  kqlQuery,
  isDisabled
}) => {
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const closePopover = () => {
    setPopoverOpen(false);
  };
  const last30MinRange = (0, _normalize_time_range.normalizeTimeRange)({
    kind: 'absolute',
    from: new Date(Date.now() - 30 * 60 * 1000).toISOString(),
    // 30 minutes in milliseconds
    to: new Date(Date.now()).toISOString()
  });
  const {
    investigateInTimeline
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)();
  const openTimelineCallback = (0, _react.useCallback)(async () => {
    investigateInTimeline({
      timeRange: {
        from: last30MinRange.from,
        to: last30MinRange.to,
        kind: 'absolute'
      },
      keepDataView: true,
      // it will reset to the Security default data view
      query: {
        language: 'kuery',
        query: kqlQuery
      }
    });
  }, [kqlQuery, last30MinRange, investigateInTimeline]);
  const smallContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'smallContextMenuPopover'
  });
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: isLoading,
    isDisabled: isDisabled,
    fill: true,
    iconType: "arrowDown",
    iconSide: "right",
    onClick: () => setPopoverOpen(!isPopoverOpen),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.takeActionButton",
    defaultMessage: "Take action",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }));
  const actionsItems = [/*#__PURE__*/_react.default.createElement(InvestigateInTimeline, {
    key: "investigateInTimeline",
    investigateInTimelineFn: openTimelineCallback,
    setIsLoading: setIsLoading,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  })];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: smallContextMenuPopoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    "data-test-subj": "take-action-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: actionsItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }));
};
exports.TakeAction = TakeAction;
const InvestigateInTimeline = ({
  investigateInTimelineFn,
  setIsLoading,
  closePopover
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "investigateInTimeline",
    onClick: async () => {
      closePopover();
      setIsLoading(true);
      await investigateInTimelineFn();
      setIsLoading(false);
    },
    "data-test-subj": "investigate-in-timeline-take-action-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Investigate in Timeline",
    id: "xpack.securitySolution.flyout.investigateInTimelineButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }));
};