"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowRelatedAlertsBySameSourceEvent = void 0;
var _field_names = require("../constants/field_names");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns kibana.alert.ancestors.id field or default eventId
 */
const useShowRelatedAlertsBySameSourceEvent = ({
  eventId,
  getFieldsData
}) => {
  var _getField;
  const originalEventId = (_getField = (0, _utils.getField)(getFieldsData(_field_names.ANCESTOR_ID))) !== null && _getField !== void 0 ? _getField : eventId;
  return {
    show: true,
    originalEventId
  };
};
exports.useShowRelatedAlertsBySameSourceEvent = useShowRelatedAlertsBySameSourceEvent;