"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilitiesInsight = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_vulnerabilities_preview = require("@kbn/cloud-security-posture/src/hooks/use_vulnerabilities_preview");
var _use_get_severity_status_color = require("@kbn/cloud-security-posture/src/hooks/use_get_severity_status_color");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _insight_distribution_bar = require("./insight_distribution_bar");
var _formatted_number = require("../../../../common/components/formatted_number");
var _preview_link = require("../../../shared/components/preview_link");
var _context = require("../context");
var _left_panel_header = require("../../../entity_details/shared/components/left_panel/left_panel_header");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/shared/components/vulnerabilities_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Displays a distribution bar and the total vulnerabilities count for a given host
 */
const VulnerabilitiesInsight = ({
  hostName,
  direction,
  'data-test-subj': dataTestSubj,
  telemetryKey,
  openDetailsPanel
}) => {
  const renderingId = (0, _eui.useGeneratedHtmlId)();
  const {
    scopeId
  } = (0, _context.useDocumentDetailsContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getSeverityStatusColor
  } = (0, _use_get_severity_status_color.useGetSeverityStatusColor)();
  const {
    data
  } = (0, _use_vulnerabilities_preview.useVulnerabilitiesPreview)({
    query: (0, _cloudSecurityPostureCommon.buildGenericEntityFlyoutPreviewQuery)('host.name', hostName),
    sort: [],
    enabled: true,
    pageSize: 1
  });
  const isNewNavigationEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newExpandableFlyoutNavigationDisabled');
  const {
    CRITICAL = 0,
    HIGH = 0,
    MEDIUM = 0,
    LOW = 0,
    NONE = 0
  } = (data === null || data === void 0 ? void 0 : data.count) || {};
  const totalVulnerabilities = (0, _react.useMemo)(() => CRITICAL + HIGH + MEDIUM + LOW + NONE, [CRITICAL, HIGH, MEDIUM, LOW, NONE]);

  // this component only renders if there are findings
  const shouldRender = (0, _react.useMemo)(() => (0, _cloudSecurityPosture.hasVulnerabilitiesData)({
    critical: CRITICAL,
    high: HIGH,
    medium: MEDIUM,
    low: LOW,
    none: NONE
  }), [CRITICAL, HIGH, MEDIUM, LOW, NONE]);
  (0, _react.useEffect)(() => {
    if (shouldRender && telemetryKey) {
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, telemetryKey);
    }
  }, [shouldRender, telemetryKey, renderingId]);
  const vulnerabilitiesStats = (0, _react.useMemo)(() => (0, _cloudSecurityPosture.getVulnerabilityStats)({
    critical: CRITICAL,
    high: HIGH,
    medium: MEDIUM,
    low: LOW,
    none: NONE
  }, getSeverityStatusColor), [CRITICAL, HIGH, MEDIUM, LOW, NONE, getSeverityStatusColor]);
  const count = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          margin-top: ${euiTheme.size.xs};
          margin-bottom: ${euiTheme.size.xs};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, isNewNavigationEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.insights.vulnerabilities.vulnerabilitiesCountTooltip",
      defaultMessage: "Opens {count, plural, one {this vulnerability} other {these vulnerabilities}} in a new flyout",
      values: {
        count: totalVulnerabilities
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": `${dataTestSubj}-count`,
    onClick: () => openDetailsPanel({
      tab: _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS,
      subTab: _left_panel_header.CspInsightLeftPanelSubTab.VULNERABILITIES
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: totalVulnerabilities,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  }))) : /*#__PURE__*/_react.default.createElement(_preview_link.PreviewLink, {
    field: 'host.name',
    value: hostName,
    scopeId: scopeId,
    "data-test-subj": `${dataTestSubj}-count`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: totalVulnerabilities,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }))), [totalVulnerabilities, hostName, scopeId, dataTestSubj, euiTheme.size, isNewNavigationEnabled, openDetailsPanel]);
  if (!shouldRender) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_insight_distribution_bar.InsightDistributionBar, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.insights.vulnerabilitiesTitle",
      defaultMessage: "Vulnerabilities:",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 11
      }
    }),
    stats: vulnerabilitiesStats,
    count: count,
    direction: direction,
    "data-test-subj": `${dataTestSubj}-distribution-bar`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }));
};
exports.VulnerabilitiesInsight = VulnerabilitiesInsight;
VulnerabilitiesInsight.displayName = 'VulnerabilitiesInsight';