"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnrichedFieldInfo = getEnrichedFieldInfo;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getEnrichedFieldInfo({
  browserFields,
  contextId,
  eventId,
  field,
  item,
  linkValueField,
  scopeId
}) {
  var _item$category, _item$field, _browserField$format$, _browserField$format, _browserField$type;
  const fieldInfo = {
    contextId,
    eventId,
    fieldType: 'string',
    linkValue: undefined,
    scopeId
  };
  const linkValue = (0, _fp.getOr)(null, 'originalValue.0', linkValueField);
  const category = (_item$category = item.category) !== null && _item$category !== void 0 ? _item$category : '';
  const fieldName = (_item$field = item.field) !== null && _item$field !== void 0 ? _item$field : '';
  const browserField = (0, _fp.get)([category, 'fields', fieldName], browserFields);
  const overrideField = field === null || field === void 0 ? void 0 : field.overrideField;
  return {
    ...fieldInfo,
    data: {
      field: overrideField !== null && overrideField !== void 0 ? overrideField : fieldName,
      format: (_browserField$format$ = browserField === null || browserField === void 0 ? void 0 : (_browserField$format = browserField.format) === null || _browserField$format === void 0 ? void 0 : _browserField$format.id) !== null && _browserField$format$ !== void 0 ? _browserField$format$ : '',
      type: (_browserField$type = browserField === null || browserField === void 0 ? void 0 : browserField.type) !== null && _browserField$type !== void 0 ? _browserField$type : '',
      isObjectArray: item.isObjectArray
    },
    values: item.values,
    linkValue: linkValue !== null && linkValue !== void 0 ? linkValue : undefined,
    fieldFromBrowserField: browserField
  };
}