"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GraphPreviewContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("@kbn/cloud-security-posture-graph/src/hooks");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _analytics = require("@kbn/analytics");
var _context = require("../../shared/context");
var _test_ids = require("./test_ids");
var _graph_preview = require("./graph_preview");
var _use_graph_preview = require("../../shared/hooks/use_graph_preview");
var _use_navigate_to_graph_visualization = require("../../shared/hooks/use_navigate_to_graph_visualization");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/graph_preview_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Graph preview under Overview, Visualizations. It shows a graph representation of entities.
 */
const GraphPreviewContainer = () => {
  const renderingId = (0, _eui.useGeneratedHtmlId)();
  const {
    dataAsNestedObject,
    getFieldsData,
    eventId,
    indexName,
    scopeId,
    isRulePreview,
    isPreviewMode,
    dataFormattedForFieldBrowser
  } = (0, _context.useDocumentDetailsContext)();
  const allowFlyoutExpansion = (0, _react.useMemo)(() => !isPreviewMode && !isRulePreview, [isRulePreview, isPreviewMode]);
  const {
    navigateToGraphVisualization
  } = (0, _use_navigate_to_graph_visualization.useNavigateToGraphVisualization)({
    eventId,
    indexName,
    isFlyoutOpen: true,
    scopeId
  });
  const {
    eventIds,
    timestamp = new Date().toISOString(),
    hasGraphRepresentation,
    isAlert
  } = (0, _use_graph_preview.useGraphPreview)({
    getFieldsData,
    ecsData: dataAsNestedObject,
    dataFormattedForFieldBrowser
  });

  // TODO: default start and end might not capture the original event
  const {
    isLoading,
    isError,
    data
  } = (0, _hooks.useFetchGraphData)({
    req: {
      query: {
        originEventIds: eventIds.map(id => ({
          id,
          isAlert
        })),
        start: `${timestamp}||-30m`,
        end: `${timestamp}||+30m`
      }
    },
    options: {
      enabled: hasGraphRepresentation,
      refetchOnWindowFocus: false
    }
  });
  (0, _react.useEffect)(() => {
    if (hasGraphRepresentation) {
      _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.LOADED, _ui_metrics.GRAPH_PREVIEW);
    }
  }, [hasGraphRepresentation, renderingId]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.graphPreview.graphPreviewTitle",
        defaultMessage: "Graph preview",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 11
        }
      }),
      headerContent: /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        alignment: "middle",
        iconType: "beaker",
        "data-test-subj": "graphPreviewBetaBadge",
        label: _i18n.i18n.translate('xpack.securitySolution.flyout.right.visualizations.graphPreview.technicalPreviewLabel', {
          defaultMessage: 'Technical Preview'
        }),
        tooltipContent: _i18n.i18n.translate('xpack.securitySolution.flyout.right.visualizations.graphPreview.technicalPreviewTooltip', {
          defaultMessage: 'This functionality is in technical preview and may be changed or removed completely in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 11
        }
      }),
      iconType: allowFlyoutExpansion ? 'arrowStart' : undefined,
      ...(allowFlyoutExpansion && {
        link: {
          callback: navigateToGraphVisualization,
          tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.flyout.right.visualizations.graphPreview.graphPreviewOpenGraphTooltip",
            defaultMessage: "Expand graph",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 119,
              columnNumber: 15
            }
          })
        }
      })
    },
    "data-test-subj": _test_ids.GRAPH_PREVIEW_TEST_ID,
    content: !isLoading && !isError ? {
      paddingSize: 'none'
    } : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_graph_preview.GraphPreview, {
    isLoading: isLoading,
    isError: isError,
    data: data,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }));
};
exports.GraphPreviewContainer = GraphPreviewContainer;
GraphPreviewContainer.displayName = 'GraphPreviewContainer';