"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_CONVERSATIONS_BUTTON_TEST_ID = exports.LOADING_SKELETON_TEST_ID = exports.Conversations = exports.CONVERSATION_COUNT_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ai_for_soc/components/conversations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LOADING_SKELETON_TEST_ID = exports.LOADING_SKELETON_TEST_ID = 'ai-for-soc-alert-flyout-conversation-loading-skeleton';
const CONVERSATION_COUNT_TEST_ID = exports.CONVERSATION_COUNT_TEST_ID = 'ai-for-soc-alert-flyout-conversation-count';
const VIEW_CONVERSATIONS_BUTTON_TEST_ID = exports.VIEW_CONVERSATIONS_BUTTON_TEST_ID = 'ai-for-soc-alert-flyout-view-conversations';
const YOUR_CONVERSATIONS = _i18n.i18n.translate('xpack.securitySolution.aiAssistant.yourConversations', {
  defaultMessage: 'Your conversations'
});
const VIEW = _i18n.i18n.translate('xpack.securitySolution.aiAssistant.view', {
  defaultMessage: 'View'
});
/**
 * Component rendered in the AI assistant section of the AI for SOC alert flyout.
 * It fetches user conversations related to the alertId passed as input.
 * If no id is provided, we display a list of default conversations.
 */
const Conversations = exports.Conversations = /*#__PURE__*/(0, _react.memo)(({
  alertId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    http,
    assistantAvailability: {
      isAssistantEnabled
    },
    showAssistantOverlay
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    data: conversations,
    isFetched: conversationsLoaded
  } = (0, _elasticAssistant.useFetchCurrentUserConversations)({
    http,
    isAssistantEnabled,
    filter: `messages:{ content : "${alertId}" }`
  });
  const conversationCount = (0, _react.useMemo)(() => Object.keys(conversations).length, [conversations]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const onSelectConversation = (0, _react.useCallback)(conversationId => {
    closePopover();
    showAssistantOverlay({
      showOverlay: true,
      selectedConversation: {
        id: conversationId
      }
    });
  }, [closePopover, showAssistantOverlay]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    color: "subdued",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, conversationsLoaded ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 21
    }
  }, YOUR_CONVERSATIONS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    css: (0, _react2.css)`
                      color: ${euiTheme.colors.textPrimary};
                    `,
    "data-test-subj": CONVERSATION_COUNT_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 19
    }
  }, conversationCount)))), conversationCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": VIEW_CONVERSATIONS_BUTTON_TEST_ID,
      iconSide: "right",
      iconType: "arrowDown",
      onClick: togglePopover,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 21
      }
    }, VIEW),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downRight",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 19
    }
  }, Object.values(conversations).map(conversation => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: conversation.id,
    onClick: () => onSelectConversation(conversation.id),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 23
    }
  }, conversation.title)))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": LOADING_SKELETON_TEST_ID,
    lines: 1,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  })));
});
Conversations.displayName = 'Conversations';