"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _model = require("../store/model");
var _constants = require("../../../../common/constants");
var _navigation = require("./navigation");
var _anomalies_query_tab_body = require("../../../common/containers/anomalies/anomalies_query_tab_body");
var _anomalies_user_table = require("../../../common/components/ml/tables/anomalies_user_table");
var _user_risk_score_tab_body = require("../../../entity_analytics/components/user_risk_score_tab_body");
var _events_tab = require("../../../common/components/events_tab");
var _helpers = require("./details/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/users/pages/users_tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UsersTabs = exports.UsersTabs = /*#__PURE__*/(0, _react.memo)(({
  deleteQuery,
  filterQuery,
  from,
  indexNames,
  isInitializing,
  setQuery,
  to,
  type
}) => {
  const tabProps = {
    deleteQuery,
    endDate: to,
    filterQuery,
    indexNames,
    skip: isInitializing || filterQuery === undefined,
    setQuery,
    startDate: from,
    type
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.USERS_PATH}/:tabName(${_model.UsersTableType.allUsers})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.AllUsersQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.USERS_PATH}/:tabName(${_model.UsersTableType.authentications})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_navigation.AuthenticationsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.USERS_PATH}/:tabName(${_model.UsersTableType.anomalies})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_anomalies_query_tab_body.AnomaliesQueryTabBody, (0, _extends2.default)({}, tabProps, {
    AnomaliesTableComponent: _anomalies_user_table.AnomaliesUserTable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.USERS_PATH}/:tabName(${_model.UsersTableType.risk})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_user_risk_score_tab_body.UserRiskScoreQueryTabBody, (0, _extends2.default)({}, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.USERS_PATH}/:tabName(${_model.UsersTableType.events})`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_events_tab.EventsQueryTabBody, (0, _extends2.default)({
    additionalFilters: _helpers.userNameExistsFilter,
    tableId: _securitysolutionDataTable.TableId.usersPageEvents
  }, tabProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }))));
});
UsersTabs.displayName = 'UsersTabs';