"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../../../common/constants");
var _details = require("./details");
var _model = require("../store/model");
var _ml_host_conditional_container = require("../../../common/components/ml/conditional_links/ml_host_conditional_container");
var _hosts = require("./hosts");
var _types = require("./types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/pages/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getHostsTabPath = () => `${_constants.HOSTS_PATH}/:tabName(` + `${_model.HostsTableType.events}|` + `${_model.HostsTableType.hosts}|` + `${_model.HostsTableType.uncommonProcesses}|` + `${_model.HostsTableType.anomalies}|` + `${_model.HostsTableType.risk}|` + `${_model.HostsTableType.sessions})`;
const getHostDetailsTabPath = () => `${_types.hostDetailsPagePath}/:tabName(` + `${_model.HostsTableType.events}|` + `${_model.HostsTableType.authentications}|` + `${_model.HostsTableType.uncommonProcesses}|` + `${_model.HostsTableType.anomalies}|` + `${_model.HostsTableType.risk}|` + `${_model.HostsTableType.sessions})`;
const HostsContainer = exports.HostsContainer = /*#__PURE__*/_react.default.memo(() => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `${_constants.HOSTS_PATH}/ml-hosts`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_ml_host_conditional_container.MlHostConditionalContainer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 7
  }
})), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Compatibility redirect for the old external alert path to events page with external alerts showing.
, {
  path: `${_constants.HOSTS_PATH}/externalAlerts`,
  render: ({
    location: {
      search = ''
    }
  }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `${_constants.HOSTS_PATH}/${_model.HostsTableType.events}`,
      search: `${search}&onlyExternalAlerts=true`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: getHostsTabPath(),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_hosts.Hosts, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 7
  }
})), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: getHostDetailsTabPath(),
  render: ({
    match: {
      params: {
        detailName
      }
    }
  }) => /*#__PURE__*/_react.default.createElement(_details.HostDetails, {
    hostDetailsPagePath: _types.hostDetailsPagePath,
    detailName: decodeURIComponent(detailName),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Redirect to the first tab when tabName is not present.
, {
  path: _types.hostDetailsPagePath,
  render: ({
    match: {
      params: {
        detailName
      }
    },
    location: {
      search = ''
    }
  }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `${_constants.HOSTS_PATH}/name/${detailName}/${_model.HostsTableType.events}`,
      search
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 70,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Compatibility redirect for the old user detail path.
, {
  path: `${_constants.HOSTS_PATH}/:detailName/:tabName?`,
  render: ({
    match: {
      params: {
        detailName,
        tabName = _model.HostsTableType.events
      }
    },
    location: {
      search = ''
    }
  }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `${_constants.HOSTS_PATH}/name/${detailName}/${tabName}`,
      search
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Redirect to the first tab when tabName is not present.
, {
  path: _constants.HOSTS_PATH,
  render: ({
    location: {
      search = ''
    }
  }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `${_constants.HOSTS_PATH}/${_model.HostsTableType.events}`,
      search
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 5
  }
})));
HostsContainer.displayName = 'HostsContainer';