"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _esQuery = require("@kbn/es-query");
var _common = require("@kbn/data-plugin/common");
var _constants = require("../../../../data_view_manager/constants");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _kuery = require("../../../../common/lib/kuery");
var _use_calculate_entity_risk_score = require("../../../../entity_analytics/api/hooks/use_calculate_entity_risk_score");
var _use_asset_criticality = require("../../../../entity_analytics/components/asset_criticality/use_asset_criticality");
var _asset_criticality_selector = require("../../../../entity_analytics/components/asset_criticality/asset_criticality_selector");
var _alerts_by_status = require("../../../../overview/components/detection_response/alerts_by_status");
var _use_signal_index = require("../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _constants2 = require("../../../../common/store/inputs/constants");
var _search_strategy = require("../../../../../common/search_strategy");
var _types = require("../../../../../common/entity_analytics/types");
var _types2 = require("../../../../app/types");
var _filters_global = require("../../../../common/components/filters_global");
var _header_page = require("../../../../common/components/header_page");
var _last_event_time = require("../../../../common/components/last_event_time");
var _anomaly_table_provider = require("../../../../common/components/ml/anomaly/anomaly_table_provider");
var _host_to_criteria = require("../../../../common/components/ml/criteria/host_to_criteria");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _tab_navigation = require("../../../../common/components/navigation/tab_navigation");
var _host_overview = require("../../../../overview/components/host_overview");
var _search_bar = require("../../../../common/components/search_bar");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _kibana = require("../../../../common/lib/kibana");
var _store = require("../../../../common/store");
var _actions = require("../../store/actions");
var _actions2 = require("../../../../common/store/inputs/actions");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _details_tabs = require("./details_tabs");
var _nav_tabs = require("./nav_tabs");
var _model = require("../../store/model");
var _helpers = require("./helpers");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _display = require("../display");
var _use_selector = require("../../../../common/hooks/use_selector");
var _details = require("../../containers/hosts/details");
var _manage_query = require("../../../../common/components/page/manage_query");
var _use_invalid_filter_query = require("../../../../common/hooks/use_invalid_filter_query");
var _containers = require("../../../../sourcerer/containers");
var _empty_prompt = require("../../../../common/components/empty_prompt");
var _alert_count_by_status = require("../../../../common/components/alert_count_by_status");
var _use_license = require("../../../../common/hooks/use_license");
var _responder = require("../../../../common/components/endpoint/responder");
var _use_refetch_overview_page_risk_score = require("../../../../entity_analytics/api/hooks/use_refetch_overview_page_risk_score");
var _model2 = require("../../../../sourcerer/store/model");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _page_loader = require("../../../../common/components/page_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/hosts/pages/details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ES_HOST_FIELD = 'host.name';
const HostOverviewManage = (0, _manage_query.manageQuery)(_host_overview.HostOverview);
const HostDetailsComponent = ({
  detailName,
  hostDetailsPagePath
}) => {
  var _experimentalDataView, _privileges$data, _hostOverview$endpoin, _hostOverview$endpoin2, _hostOverview$endpoin3, _hostOverview$endpoin4;
  const dispatch = (0, _reactRedux.useDispatch)();
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  const hostDetailsPageFilters = (0, _react.useMemo)(() => (0, _helpers.getHostDetailsPageFilters)(detailName), [detailName]);
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions2.setAbsoluteRangeDatePicker)({
      id: _constants2.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const {
    indicesExist: oldIndicesExist,
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_constants.DataViewManagerScopeName.explore);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.DataViewManagerScopeName.explore);
  const indicesExist = newDataViewPickerEnabled ? !!((_experimentalDataView = experimentalDataView.matchedIndices) !== null && _experimentalDataView !== void 0 && _experimentalDataView.length) : oldIndicesExist;
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const [loading, {
    inspect,
    hostDetails: hostOverview,
    id,
    refetch
  }] = (0, _details.useHostDetails)({
    endDate: to,
    startDate: from,
    hostName: detailName,
    indexNames: selectedPatterns,
    skip: selectedPatterns.length === 0
  });
  const [rawFilteredQuery, kqlError] = (0, _react.useMemo)(() => {
    try {
      return [(0, _esQuery.buildEsQuery)(newDataViewPickerEnabled ? experimentalDataView : (0, _kuery.dataViewSpecToViewBase)(oldSourcererDataView), [query], [...hostDetailsPageFilters, ...globalFilters], (0, _common.getEsQueryConfig)(uiSettings))];
    } catch (e) {
      return [undefined, e];
    }
  }, [newDataViewPickerEnabled, experimentalDataView, oldSourcererDataView, query, hostDetailsPageFilters, globalFilters, uiSettings]);
  const stringifiedAdditionalFilters = JSON.stringify(rawFilteredQuery);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: _details.ID,
    filterQuery: stringifiedAdditionalFilters,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  (0, _react.useEffect)(() => {
    dispatch((0, _actions.setHostDetailsTablesActivePageToZero)());
  }, [dispatch, detailName]);
  const {
    hasKibanaREAD,
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const canReadAlerts = hasKibanaREAD && hasIndexRead;
  const entityFilter = (0, _react.useMemo)(() => ({
    field: ES_HOST_FIELD,
    value: detailName
  }), [detailName]);
  const additionalFilters = (0, _react.useMemo)(() => rawFilteredQuery ? [rawFilteredQuery] : [], [rawFilteredQuery]);
  const entity = (0, _react.useMemo)(() => ({
    type: _types.EntityType.host,
    name: detailName
  }), [detailName]);
  const privileges = (0, _use_asset_criticality.useAssetCriticalityPrivileges)(entity.name);
  const refetchRiskScore = (0, _use_refetch_overview_page_risk_score.useRefetchOverviewPageRiskScore)(_host_overview.HOST_OVERVIEW_RISK_SCORE_QUERY_ID);
  const {
    calculateEntityRiskScore
  } = (0, _use_calculate_entity_risk_score.useCalculateEntityRiskScore)(_types.EntityType.host, detailName, {
    onSuccess: refetchRiskScore
  });
  const canReadAssetCriticality = !!((_privileges$data = privileges.data) !== null && _privileges$data !== void 0 && _privileges$data.has_read_permissions);
  const criticality = (0, _use_asset_criticality.useAssetCriticalityData)({
    entity,
    enabled: canReadAssetCriticality,
    onChange: calculateEntityRiskScore
  });
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants2.InputsModelId.global,
    sourcererDataView: newDataViewPickerEnabled ? experimentalDataView : oldSourcererDataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    "data-test-subj": "hostDetailsPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    border: true,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _search_strategy.LastEventIndexKey.hostDetails,
      hostName: detailName,
      indexNames: selectedPatterns,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 252,
        columnNumber: 19
      }
    }),
    title: detailName,
    rightSideItems: [((_hostOverview$endpoin = hostOverview.endpoint) === null || _hostOverview$endpoin === void 0 ? void 0 : (_hostOverview$endpoin2 = _hostOverview$endpoin.hostInfo) === null || _hostOverview$endpoin2 === void 0 ? void 0 : _hostOverview$endpoin2.metadata.elastic.agent.id) && /*#__PURE__*/_react.default.createElement(_responder.ResponderActionButton, {
      agentId: (_hostOverview$endpoin3 = hostOverview.endpoint) === null || _hostOverview$endpoin3 === void 0 ? void 0 : (_hostOverview$endpoin4 = _hostOverview$endpoin3.hostInfo) === null || _hostOverview$endpoin4 === void 0 ? void 0 : _hostOverview$endpoin4.metadata.elastic.agent.id,
      agentType: "endpoint",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 21
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 15
    }
  }), canReadAssetCriticality && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalityTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalitySelector, {
    compressed: true,
    criticality: criticality,
    entity: entity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _host_to_criteria.hostToCriteria)(hostOverview),
    startDate: from,
    endDate: to,
    skip: isInitializing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 15
    }
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(HostOverviewManage, {
    id: id,
    isInDetailsSidePanel: false,
    data: hostOverview,
    anomaliesData: anomaliesData,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    loading: loading,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    setQuery: setQuery,
    refetch: refetch,
    inspect: inspect,
    hostName: detailName,
    indexNames: selectedPatterns,
    jobNameById: jobNameById,
    scopeId: _model2.SourcererScopeName.explore,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 15
    }
  }), canReadAlerts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_by_status.AlertsByStatus, {
    signalIndexName: signalIndexName,
    entityFilter: entityFilter,
    additionalFilters: additionalFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_count_by_status.AlertCountByRuleByStatus, {
    entityFilter: entityFilter,
    signalIndexName: signalIndexName,
    additionalFilters: additionalFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 23
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: (0, _nav_tabs.navTabsHostDetails)({
      hasMlUserPermissions: (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities),
      hostName: detailName,
      isEnterprise: isEnterprisePlus
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_details_tabs.HostDetailsTabs, {
    indexNames: selectedPatterns,
    isInitializing: isInitializing,
    deleteQuery: deleteQuery,
    hostDetailsFilter: hostDetailsPageFilters,
    to: to,
    from: from,
    detailName: detailName,
    type: _model.HostsType.details,
    setQuery: setQuery,
    filterQuery: stringifiedAdditionalFilters,
    hostDetailsPagePath: hostDetailsPagePath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types2.SecurityPageName.hosts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 7
    }
  }));
};
HostDetailsComponent.displayName = 'HostDetailsComponent';
const HostDetails = exports.HostDetails = /*#__PURE__*/_react.default.memo(HostDetailsComponent);