"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskEnginePrivilegesCallOut = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _callouts = require("../../../common/components/callouts");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/risk_engine_privileges_callout/risk_engine_privileges_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RiskEnginePrivilegesCallOut = ({
  privileges
}) => {
  if (privileges.isLoading || privileges.hasAllRequiredPrivileges) {
    return null;
  }
  const message = {
    type: 'primary',
    id: `missing-risk-engine-privileges`,
    title: _translations.MISSING_PRIVILEGES_CALLOUT_TITLE,
    description: /*#__PURE__*/_react.default.createElement(_translations.MissingPrivilegesCallOutBody, (0, _extends2.default)({}, privileges.missingPrivileges, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 25,
        columnNumber: 18
      }
    }))
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_callouts.CallOut, {
    message: message,
    showDismissButton: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }));
};
exports.RiskEnginePrivilegesCallOut = RiskEnginePrivilegesCallOut;