"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedUserMonitoringErrorStep = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _helpers = require("../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring_onboarding/components/file_uploader/components/error_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PrivilegedUserMonitoringErrorStep = ({
  result,
  validLinesAsText,
  errorMessage,
  goToFirstStep,
  onClose
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (errorMessage !== undefined) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      iconType: "cross",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.errorTitle",
        defaultMessage: "Error uploading file",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 13
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 11
      }
    }, errorMessage)), /*#__PURE__*/_react.default.createElement(ErrorStepFooter, {
      onTryAgain: goToFirstStep,
      onClose: onClose,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }));
  }
  if (result === undefined || result.stats.failed === 0) {
    return null;
  }
  const annotations = (0, _helpers.buildAnnotationsFromError)(result.errors);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Some privileged user assignments were unsuccessful due to errors.",
      id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 11
      }
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{assignedCount, plural, one {# privileged user assignment succeeded.} other {# privileged user assignments succeeded.}}",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.assignedEntities",
    values: {
      assignedCount: result.stats.successful
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: euiTheme.colors.danger,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "{failedCount, plural, one {# privileged user assignment failed.} other {# privileged user assignments failed.}}",
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.failedEntities",
    values: {
      failedCount: result.stats.failed
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    overflowHeight: 300,
    language: "CSV",
    isVirtualized: true,
    css: (0, _react2.css)`
            border: 1px solid ${euiTheme.colors.warning};
          `,
    lineNumbers: {
      annotations
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, validLinesAsText)), /*#__PURE__*/_react.default.createElement(ErrorStepFooter, {
    onTryAgain: goToFirstStep,
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }));
};
exports.PrivilegedUserMonitoringErrorStep = PrivilegedUserMonitoringErrorStep;
const ErrorStepFooter = ({
  onTryAgain,
  onClose
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 114,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween",
  gutterSize: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 115,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 116,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  onClick: onClose,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 117,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.cancelButton",
  defaultMessage: "Cancel",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 118,
    columnNumber: 11
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 124,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
  onClick: onTryAgain,
  color: "primary",
  fill: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 125,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.fileUploader.errorStep.tryAgainButton",
  defaultMessage: "Try again",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 126,
    columnNumber: 11
  }
})))));