"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingPrivilegesCallout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _line_clamp = require("../../common/components/line_clamp");
var _privileges = require("../../../common/entity_analytics/privileges");
var _missing_privileges = require("../../common/components/missing_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/missing_privileges_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * The height of the callout when the content is clamped.
 * The value was chosen based on trial and error.
 */
const LINE_CLAMP_HEIGHT = '4.4em';
const MissingPrivilegesCallout = exports.MissingPrivilegesCallout = /*#__PURE__*/_react.default.memo(({
  privileges,
  title
}) => {
  var _missingPrivileges$el, _missingPrivileges$el2;
  const missingPrivileges = (0, _privileges.getAllMissingPrivileges)(privileges);
  const indexPrivileges = (_missingPrivileges$el = missingPrivileges.elasticsearch.index) !== null && _missingPrivileges$el !== void 0 ? _missingPrivileges$el : {};
  const clusterPrivileges = (_missingPrivileges$el2 = missingPrivileges.elasticsearch.cluster) !== null && _missingPrivileges$el2 !== void 0 ? _missingPrivileges$el2 : {};
  const featurePrivileges = missingPrivileges.kibana;
  const id = `missing-privileges-callout`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    title: title,
    iconType: 'info',
    "data-test-subj": `callout-${id}`,
    "data-test-messages": `[${id}]`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_line_clamp.LineClamp, {
    maxHeight: "100%",
    lineClampHeight: LINE_CLAMP_HEIGHT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, indexPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.indexPrivilegesTitle",
    defaultMessage: "Missing Elasticsearch index privileges:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 17
    }
  }, indexPrivileges.map(({
    indexName,
    privileges: privilege
  }) => /*#__PURE__*/_react.default.createElement("li", {
    key: indexName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.missingIndexPrivileges",
    defaultMessage: "Missing {privileges} privileges for the {index} index.",
    values: {
      privileges: /*#__PURE__*/_react.default.createElement(_missing_privileges.CommaSeparatedValues, {
        values: privilege,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 39
        }
      }),
      index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 34
        }
      }, indexName)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 23
    }
  }))))) : null, clusterPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.clusterPrivilegesTitle",
    defaultMessage: "Missing Elasticsearch cluster privileges:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 17
    }
  }, clusterPrivileges.map(privilege => /*#__PURE__*/_react.default.createElement("li", {
    key: privilege,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 23
    }
  }, privilege))))) : null, featurePrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.featurePrivilegesTitle",
    defaultMessage: "Missing Kibana feature privileges:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 17
    }
  }, featurePrivileges.map(feature => /*#__PURE__*/_react.default.createElement("li", {
    key: feature,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.riskEngine.missingPrivilegesCallOut.messageBody.missingFeaturePrivileges",
    defaultMessage: "Missing privilege for the {feature} feature.",
    values: {
      feature: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 36
        }
      }, feature)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 23
    }
  }))))) : null)));
});
MissingPrivilegesCallout.displayName = 'MissingPrivilegesCallout';