"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityStoreEnablementModal = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _entity_analytics = require("../../../../../common/api/entity_analytics");
var _use_contract_component = require("../../../../common/hooks/use_contract_component");
var _translations = require("../translations");
var _entity_store_missing_privileges_callout = require("./entity_store_missing_privileges_callout");
var _use_missing_risk_engine_privileges = require("../../../hooks/use_missing_risk_engine_privileges");
var _risk_engine_privileges_callout = require("../../risk_engine_privileges_callout");
var _use_entity_engine_privileges = require("../hooks/use_entity_engine_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_store/components/enablement_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isInstallButtonEnabled = (canInstallRiskScore, canInstallEntityStore, userHasEnabled) => {
  if (canInstallRiskScore || canInstallEntityStore) {
    return userHasEnabled.riskScore || userHasEnabled.entityStore;
  }
  return false;
};
const ENTITY_STORE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.enablements.modal.store', {
  defaultMessage: 'Entity Store'
});
const EntityStoreEnablementModal = ({
  visible,
  toggle,
  enableStore,
  riskEngineStatus,
  entityStoreStatus
}) => {
  const riskEnginePrivileges = (0, _use_missing_risk_engine_privileges.useMissingRiskEnginePrivileges)();
  const {
    data: entityEnginePrivileges,
    isLoading: isLoadingEntityEnginePrivileges
  } = (0, _use_entity_engine_privileges.useEntityEnginePrivileges)();
  const hasRiskScorePrivileges = !(riskEnginePrivileges.isLoading || !(riskEnginePrivileges !== null && riskEnginePrivileges !== void 0 && riskEnginePrivileges.hasAllRequiredPrivileges));
  const canInstallRiskScore = hasRiskScorePrivileges && riskEngineStatus === _entity_analytics.RiskEngineStatusEnum.NOT_INSTALLED;
  const hasEntityStorePrivileges = !(isLoadingEntityEnginePrivileges || !(entityEnginePrivileges !== null && entityEnginePrivileges !== void 0 && entityEnginePrivileges.has_all_required));
  const canInstallEntityStore = hasEntityStorePrivileges && entityStoreStatus === 'not_installed';
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [toggleState, setToggleState] = (0, _react2.useState)({
    riskScore: false,
    entityStore: false
  });

  /**
   * Update the toggle state when the install status changes because privileges are async.
   * We automatically toggle the switch when the user can enable the engine.
   *
   */
  (0, _react2.useEffect)(() => {
    setToggleState({
      riskScore: canInstallRiskScore,
      entityStore: canInstallEntityStore
    });
  }, [canInstallRiskScore, canInstallEntityStore]);
  const isInstallButtonDisabled = !isInstallButtonEnabled(canInstallRiskScore, canInstallEntityStore, toggleState);
  const {
    AdditionalChargesMessage
  } = (0, _use_contract_component.useContractComponents)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!visible) {
    return null;
  }
  const proceedWarning = /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "danger",
    css: (0, _react.css)`
        border-radius: ${euiTheme.border.radius.medium};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, _translations.ENABLEMENT_WARNING_SELECT_TO_PROCEED));
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiModal, {
    onClose: () => toggle(false),
    "aria-labelledby": modalTitleId,
    "data-test-subj": "entityStoreEnablementModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.enablements.modal.title",
    defaultMessage: "Entity Analytics Enablement",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, AdditionalChargesMessage && /*#__PURE__*/_react2.default.createElement(AdditionalChargesMessage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 53
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.entityAnalytics.enablements.modal.risk",
      defaultMessage: "Risk Score",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 17
      }
    }),
    checked: toggleState.riskScore,
    disabled: !canInstallRiskScore,
    onChange: () => setToggleState(prev => ({
      ...prev,
      riskScore: !prev.riskScore
    })),
    "data-test-subj": "enablementRiskScoreSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  })), !riskEnginePrivileges.isLoading && !riskEnginePrivileges.hasAllRequiredPrivileges && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_risk_engine_privileges_callout.RiskEnginePrivilegesCallOut, {
    privileges: riskEnginePrivileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }, _translations.ENABLEMENT_DESCRIPTION_RISK_ENGINE_ONLY)), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSwitch, {
    label: ENTITY_STORE,
    checked: toggleState.entityStore,
    disabled: !canInstallEntityStore,
    onChange: () => setToggleState(prev => ({
      ...prev,
      entityStore: !prev.entityStore
    })),
    "data-test-subj": "enablementEntityStoreSwitch",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }))), !entityEnginePrivileges || entityEnginePrivileges.has_all_required ? null : /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_entity_store_missing_privileges_callout.EntityStoreMissingPrivilegesCallout, {
    privileges: entityEnginePrivileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 13
    }
  }, _translations.ENABLEMENT_DESCRIPTION_ENTITY_STORE_ONLY)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }, isInstallButtonDisabled && (canInstallRiskScore || canInstallEntityStore) ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  }, proceedWarning) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => toggle(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 15
    }
  }, 'Cancel'), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    onClick: enableStore(toggleState),
    fill: true,
    isDisabled: isInstallButtonDisabled,
    "aria-disabled": isInstallButtonDisabled,
    "data-test-subj": "entityStoreEnablementModalButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.enablements.modal.enable",
    defaultMessage: "Enable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 17
    }
  })))))));
};
exports.EntityStoreEnablementModal = EntityStoreEnablementModal;