"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TotalAnomalies = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../../../../../common/machine_learning/helpers");
var i18n = _interopRequireWildcard(require("../translations"));
var _anomalies_tab_link = require("./anomalies_tab_link");
var _enable_job = require("./enable_job");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_analytics_anomalies/components/total_anomalies.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TotalAnomalies = ({
  count,
  job,
  entity,
  recentlyEnabledJobIds,
  loading,
  onJobEnabled
}) => {
  if ((0, _helpers.isJobLoading)(job.jobState, job.datafeedState)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.JOB_STATUS_WAITING);
  } else if ((0, _helpers.isJobFailed)(job.jobState, job.datafeedState)) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.JOB_STATUS_FAILED);
  } else if (count > 0 || (0, _helpers.isJobStarted)(job.jobState, job.datafeedState) || recentlyEnabledJobIds.includes(job.id)) {
    return /*#__PURE__*/_react.default.createElement(_anomalies_tab_link.AnomaliesTabLink, {
      count: count,
      jobId: job.id,
      entity: entity,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 12
      }
    });
  } else if (job.isCompatible) {
    return /*#__PURE__*/_react.default.createElement(_enable_job.EnableJob, {
      job: job,
      isLoading: loading,
      onJobEnabled: onJobEnabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 12
      }
    });
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": "Warning",
      size: "s",
      type: "warning",
      color: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 12
      }
    });
  }
};
exports.TotalAnomalies = TotalAnomalies;