"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _alert_summary = require("./pages/alert_summary");
var _constants = require("../../common/constants");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _alerts = require("./pages/alerts");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AlertsRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 23,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_alerts.Alerts, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 24,
    columnNumber: 5
  }
}));
const DetectionsRedirects = ({
  location
}) => location.pathname === _constants.DETECTIONS_PATH ? /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  to: {
    ...location,
    pathname: _constants.ALERTS_PATH
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 5
  }
}) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  to: {
    ...location,
    pathname: location.pathname.replace(_constants.DETECTIONS_PATH, '')
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 5
  }
});
const routes = exports.routes = [{
  path: _constants.DETECTIONS_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(DetectionsRedirects, _constants.SecurityPageName.detections)
}, {
  path: _constants.ALERTS_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(AlertsRoutes, _constants.SecurityPageName.alerts)
}, {
  path: _constants.ALERT_SUMMARY_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(_alert_summary.AlertSummaryContainer, _constants.SecurityPageName.alertSummary)
}];