"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FullWidthFlexGroupTable = exports.AlertsTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionRules = require("@kbn/securitysolution-rules");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/data-plugin/public");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _lodash = require("lodash");
var _responseOpsAlertsTable = require("@kbn/response-ops-alerts-table");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _alerts_context = require("./alerts_context");
var _use_bulk_actions = require("../../hooks/trigger_actions_alert_table/use_bulk_actions");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _actions_cell = require("./actions_cell");
var _use_global_time = require("../../../common/containers/use_global_time");
var _use_license = require("../../../common/hooks/use_license");
var _constants = require("../../../../common/constants");
var _constants2 = require("../../../timelines/components/timeline/body/constants");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _default_model = require("../../../common/components/events_viewer/default_model");
var _store = require("../../../common/store");
var _kuery = require("../../../common/lib/kuery");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _stateful_event_context = require("../../../common/components/events_viewer/stateful_event_context");
var _containers = require("../../../sourcerer/containers");
var _model = require("../../../sourcerer/store/model");
var _kibana = require("../../../common/lib/kibana");
var _use_selector = require("../../../common/hooks/use_selector");
var _security_solution_detections = require("../../configurations/security_solution_detections");
var _helpers = require("./helpers");
var _user_privileges = require("../../../common/components/user_privileges");
var i18n = _interopRequireWildcard(require("./translations"));
var _columns = require("../../configurations/security_solution_detections/columns");
var _default_config = require("./default_config");
var _use_fetch_notes = require("../../../notes/hooks/use_fetch_notes");
var _control_columns = require("../../../timelines/components/timeline/body/control_columns");
var _additional_toolbar_controls = require("./additional_toolbar_controls");
var _fetch_page_context = require("../../configurations/security_solution_detections/fetch_page_context");
var _use_cell_actions = require("../../hooks/trigger_actions_alert_table/use_cell_actions");
var _use_trigger_actions_browser_fields_options = require("../../hooks/trigger_actions_alert_table/use_trigger_actions_browser_fields_options");
var _cell_value_context = require("../../configurations/security_solution_detections/cell_value_context");
var _use_browser_fields = require("../../../data_view_manager/hooks/use_browser_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  updateIsLoading,
  updateTotalCount
} = _securitysolutionDataTable.dataTableActions;

// we show a maximum of 6 action buttons
// - open flyout
// - investigate in timeline
// - 3-dot menu for more actions
// - add new note
// - session view
// - analyzer graph
const MAX_ACTION_BUTTON_COUNT = 6;
const DEFAULT_DATA_GRID_HEIGHT = 600;
const ALERT_TABLE_CONSUMERS = [_ruleDataUtils.AlertConsumers.SIEM];

// Highlight rows with building block alerts
const shouldHighlightRow = alert => !!alert[_ruleDataUtils.ALERT_BUILDING_BLOCK_TYPE];
const FullWidthFlexGroupTable = exports.FullWidthFlexGroupTable = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  overflow: hidden;
  margin: 0;
  display: flex;
`;
const EuiDataGridContainer = _styledComponents.default.div`
  ul.euiPagination__list {
    li.euiPagination__item:last-child {
      ${({
  hideLastPage
}) => {
  return `${hideLastPage ? 'display:none' : ''}`;
}};
    }
  }

  div .euiDataGridRowCell {
    display: flex;
    align-items: center;
  }

  div .euiDataGridRowCell > [data-focus-lock-disabled] {
    display: flex;
    align-items: center;
    flex-grow: 1;
    width: 100%;
  }

  div .euiDataGridRowCell__content {
    flex-grow: 1;
  }

  div .siemEventsTable__trSupplement--summary {
    display: block;
  }

  width: 100%;
`;
const sort = [{
  '@timestamp': {
    order: 'desc'
  }
}];
const casesConfiguration = {
  featureId: _constants.CASES_FEATURE_ID,
  owner: [_constants.APP_ID],
  syncAlerts: true,
  extractObservables: true
};
const emptyInputFilters = [];
const AlertsTableComponent = ({
  inputFilters = emptyInputFilters,
  tableType = _securitysolutionDataTable.TableId.alertsOnAlertsPage,
  sourcererScope = _model.SourcererScopeName.detections,
  isLoading,
  onRuleChange,
  disableAdditionalToolbarControls,
  ...tablePropsOverrides
}) => {
  var _tableContext$alerts, _tableContext$columns, _alertsTableRef$curre2;
  const {
    id
  } = tablePropsOverrides;
  const {
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    uiSettings,
    settings,
    cases
  } = (0, _kibana.useKibana)().services;
  const {
    alertsTableRef
  } = (0, _alerts_context.useAlertsContext)();
  const {
    from,
    to,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const timelineID = tableType;
  // Store context in state rather than creating object in provider value={} to prevent re-renders caused by a new object being created
  const [activeStatefulEventContext] = (0, _react.useState)({
    timelineID,
    tabType: 'query',
    enableHostDetailsFlyout: true,
    enableIpDetailsFlyout: true,
    onRuleChange
  });
  const {
    browserFields: oldBrowserFields,
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)(sourcererScope);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(sourcererScope);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(sourcererScope);
  const runtimeMappings = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalDataView.getRuntimeMappings() : oldSourcererDataView.runtimeFieldMap, [newDataViewPickerEnabled, experimentalDataView, oldSourcererDataView]);
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields;
  const license = (0, _use_license.useLicense)();
  const isEnterprisePlus = license.isEnterprise();
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const globalQuery = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const licenseDefaults = (0, _react.useMemo)(() => (0, _default_config.getAlertsDefaultModel)(license), [license]);
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const {
    initialized: isDataTableInitialized,
    viewMode: tableView = _default_model.eventsDefaultModel.viewMode,
    columns,
    totalCount: count
  } = (0, _reactRedux.useSelector)(state => {
    var _getTable;
    return (_getTable = getTable(state, tableType)) !== null && _getTable !== void 0 ? _getTable : licenseDefaults;
  });
  const timeRangeFilter = (0, _react.useMemo)(() => (0, _helpers.buildTimeRangeFilter)(from, to), [from, to]);
  const allFilters = (0, _react.useMemo)(() => {
    return [...inputFilters, ...(globalFilters !== null && globalFilters !== void 0 ? globalFilters : []), ...(timeRangeFilter !== null && timeRangeFilter !== void 0 ? timeRangeFilter : [])];
  }, [inputFilters, globalFilters, timeRangeFilter]);
  const combinedQuery = (0, _react.useMemo)(() => {
    if (browserFields != null && (oldSourcererDataView || experimentalDataView)) {
      return (0, _kuery.combineQueries)({
        config: (0, _public.getEsQueryConfig)(uiSettings),
        dataProviders: [],
        dataViewSpec: oldSourcererDataView,
        dataView: experimentalDataView,
        browserFields,
        filters: [...allFilters],
        kqlQuery: globalQuery,
        kqlMode: globalQuery.language
      });
    }
    return null;
  }, [browserFields, oldSourcererDataView, uiSettings, experimentalDataView, allFilters, globalQuery]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: tableType,
    filterQuery: combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.filterQuery,
    kqlError: combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.kqlError,
    query: globalQuery,
    startDate: from,
    endDate: to
  });
  const finalBoolQuery = (0, _react.useMemo)(() => {
    if (combinedQuery !== null && combinedQuery !== void 0 && combinedQuery.kqlError || !(combinedQuery !== null && combinedQuery !== void 0 && combinedQuery.filterQuery)) {
      return {
        bool: {}
      };
    }
    return {
      bool: {
        filter: JSON.parse(combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.filterQuery)
      }
    };
  }, [combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.filterQuery, combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.kqlError]);
  const isEventRenderedView = tableView === _constants.VIEW_SELECTION.eventRenderedView;
  const gridStyle = (0, _react.useMemo)(() => ({
    border: 'none',
    fontSize: 's',
    header: 'underline',
    stripes: isEventRenderedView
  }), [isEventRenderedView]);
  const rowHeightsOptions = (0, _react.useMemo)(() => {
    if (isEventRenderedView) {
      return {
        defaultHeight: 'auto'
      };
    }
    return undefined;
  }, [isEventRenderedView]);
  const alertColumns = (0, _react.useMemo)(() => columns.length ? columns : (0, _security_solution_detections.getColumns)(license), [columns, license]);
  const finalBrowserFields = (0, _react.useMemo)(() => isEventRenderedView ? {} : browserFields, [isEventRenderedView, browserFields]);
  const finalColumns = (0, _react.useMemo)(() => isEventRenderedView ? _columns.eventRenderedViewColumns : alertColumns, [alertColumns, isEventRenderedView]);
  const {
    onLoad
  } = (0, _use_fetch_notes.useFetchNotes)();
  const [tableContext, setTableContext] = (0, _react.useState)();
  const onUpdate = (0, _react.useCallback)(context => {
    var _context$isLoading, _context$alertsCount, _context$isLoading2, _context$refresh;
    setTableContext(context);
    dispatch(updateIsLoading({
      id: tableType,
      isLoading: (_context$isLoading = context.isLoading) !== null && _context$isLoading !== void 0 ? _context$isLoading : true
    }));
    dispatch(updateTotalCount({
      id: tableType,
      totalCount: (_context$alertsCount = context.alertsCount) !== null && _context$alertsCount !== void 0 ? _context$alertsCount : -1
    }));
    setQuery({
      id: tableType,
      loading: (_context$isLoading2 = context.isLoading) !== null && _context$isLoading2 !== void 0 ? _context$isLoading2 : true,
      refetch: (_context$refresh = context.refresh) !== null && _context$refresh !== void 0 ? _context$refresh : _lodash.noop,
      inspect: null
    });
  }, [dispatch, setQuery, tableType]);
  const userProfiles = (0, _fetch_page_context.useFetchUserProfilesFromAlerts)({
    alerts: (_tableContext$alerts = tableContext === null || tableContext === void 0 ? void 0 : tableContext.alerts) !== null && _tableContext$alerts !== void 0 ? _tableContext$alerts : [],
    columns: (_tableContext$columns = tableContext === null || tableContext === void 0 ? void 0 : tableContext.columns) !== null && _tableContext$columns !== void 0 ? _tableContext$columns : []
  });
  let ACTION_BUTTON_COUNT = MAX_ACTION_BUTTON_COUNT;

  // hiding the session view icon for users without enterprise plus license
  if (!isEnterprisePlus) {
    ACTION_BUTTON_COUNT--;
  }
  const {
    timelinePrivileges: {
      read: canReadTimelines
    },
    notesPrivileges: {
      read: canReadNotes
    }
  } = (0, _user_privileges.useUserPrivileges)();

  // remove space if investigate timeline icon shouldn't be displayed
  if (!canReadTimelines) {
    ACTION_BUTTON_COUNT--;
  }

  // remove space if add notes icon shouldn't be displayed
  const securitySolutionNotesDisabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('securitySolutionNotesDisabled');
  if (!canReadNotes || securitySolutionNotesDisabled) {
    ACTION_BUTTON_COUNT--;
  }
  const leadingControlColumn = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT)[0], [ACTION_BUTTON_COUNT]);
  const additionalContext = (0, _react.useMemo)(() => ({
    rowRenderers: _renderers.defaultRowRenderers,
    isDetails: false,
    truncate: true,
    isDraggable: false,
    leadingControlColumn,
    userProfiles,
    tableType,
    sourcererScope
  }), [leadingControlColumn, sourcererScope, tableType, userProfiles]);
  const refreshAlertsTable = (0, _react.useCallback)(() => {
    var _alertsTableRef$curre;
    (_alertsTableRef$curre = alertsTableRef.current) === null || _alertsTableRef$curre === void 0 ? void 0 : _alertsTableRef$curre.refresh();
  }, [alertsTableRef]);
  const fieldsBrowserOptions = (0, _use_trigger_actions_browser_fields_options.useAlertsTableFieldsBrowserOptions)(_model.SourcererScopeName.detections, (_alertsTableRef$curre2 = alertsTableRef.current) === null || _alertsTableRef$curre2 === void 0 ? void 0 : _alertsTableRef$curre2.toggleColumn);
  const cellActionsOptions = (0, _use_cell_actions.useCellActionsOptions)(tableType, tableContext);
  const bulkActions = (0, _use_bulk_actions.useBulkActionsByTableType)(tableType, finalBoolQuery, refreshAlertsTable);
  (0, _react.useEffect)(() => {
    if (isDataTableInitialized) return;
    dispatch(_securitysolutionDataTable.dataTableActions.initializeDataTableSettings({
      id: tableType,
      title: i18n.SESSIONS_TITLE,
      defaultColumns: finalColumns.map(c => ({
        initialWidth: _constants2.DEFAULT_COLUMN_MIN_WIDTH,
        ...c
      }))
    }));
  }, [dispatch, tableType, finalColumns, isDataTableInitialized]);
  const toolbarVisibility = (0, _react.useMemo)(() => ({
    showColumnSelector: !isEventRenderedView,
    showSortSelector: !isEventRenderedView
  }), [isEventRenderedView]);
  const services = (0, _react.useMemo)(() => ({
    data,
    http,
    notifications,
    fieldFormats,
    application,
    licensing,
    settings,
    cases
  }), [application, data, fieldFormats, http, licensing, notifications, settings, cases]);

  /**
   * if records are too less, we don't want table to be of fixed height.
   * it should shrink to the content height.
   * Height setting enables/disables virtualization depending on fixed/undefined height values respectively.
   * */
  const alertTableHeight = (0, _react.useMemo)(() => isEventRenderedView ? `${DEFAULT_DATA_GRID_HEIGHT}px` :
  /*
  * We keep fixed height in Event rendered because of the row height issue
  * as mentioned here
  */
  count > 20 ? `${DEFAULT_DATA_GRID_HEIGHT}px` : undefined, [count, isEventRenderedView]);
  const onLoaded = (0, _react.useCallback)(({
    alerts
  }) => onLoad(alerts), [onLoad]);

  /**
   * We want to hide additional controls (like grouping) if the table is being rendered
   * in the cases page OR if the user of the table explicitly set `disableAdditionalToolbarControls`
   * to true
   */
  const shouldRenderAdditionalToolbarControls = disableAdditionalToolbarControls || tableType === _securitysolutionDataTable.TableId.alertsOnCasePage;
  if (isLoading) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(FullWidthFlexGroupTable, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_stateful_event_context.StatefulEventContext.Provider, {
    value: activeStatefulEventContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 463,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(EuiDataGridContainer, {
    hideLastPage: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 464,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_cell_value_context.AlertTableCellContextProvider, {
    tableId: tableType,
    sourcererScope: _model.SourcererScopeName.detections,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_responseOpsAlertsTable.AlertsTable, (0, _extends2.default)({
    ref: alertsTableRef
    // Stores separate configuration based on the view of the table
    ,
    id: id !== null && id !== void 0 ? id : `detection-engine-alert-table-${tableType}-${tableView}`,
    ruleTypeIds: _securitysolutionRules.SECURITY_SOLUTION_RULE_TYPE_IDS,
    consumers: ALERT_TABLE_CONSUMERS,
    query: finalBoolQuery,
    sort: sort,
    casesConfiguration: casesConfiguration,
    gridStyle: gridStyle,
    shouldHighlightRow: shouldHighlightRow,
    rowHeightsOptions: rowHeightsOptions,
    columns: finalColumns,
    browserFields: finalBrowserFields,
    onUpdate: onUpdate,
    onLoaded: onLoaded,
    additionalContext: additionalContext,
    height: alertTableHeight,
    pageSize: 50,
    runtimeMappings: runtimeMappings,
    toolbarVisibility: toolbarVisibility,
    renderCellValue: _security_solution_detections.CellValue,
    renderActionsCell: _actions_cell.ActionsCell,
    renderAdditionalToolbarControls: shouldRenderAdditionalToolbarControls ? undefined : _additional_toolbar_controls.AdditionalToolbarControls,
    actionsColumnWidth: leadingControlColumn.width,
    additionalBulkActions: bulkActions,
    fieldsBrowserOptions: tableType === _securitysolutionDataTable.TableId.alertsOnAlertsPage || tableType === _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage ? fieldsBrowserOptions : undefined,
    cellActionsOptions: cellActionsOptions,
    showInspectButton: true,
    services: services
  }, tablePropsOverrides, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 13
    }
  }))))));
};
const AlertsTable = exports.AlertsTable = /*#__PURE__*/(0, _react.memo)(AlertsTableComponent);