"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaAlertSeverityCellRenderer = exports.BADGE_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _helpers = require("../../alerts_kpis/severity_level_panel/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/table/kibana_alert_severity_cell_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BADGE_TEST_ID = exports.BADGE_TEST_ID = 'alert-summary-table-severity-cell-renderer';

/**
 * Return the same string with the first letter capitalized
 */
const capitalizeFirstLetter = value => String(value).charAt(0).toUpperCase() + String(value).slice(1);
/**
 * Renders a EuiBadge for the kibana.alert.severity field.
 * Used in AI for SOC alert summary table.
 */
const KibanaAlertSeverityCellRenderer = exports.KibanaAlertSeverityCellRenderer = /*#__PURE__*/(0, _react.memo)(({
  alert
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const displayValue = (0, _react.useMemo)(() => {
    const values = alert[_ruleDataUtils.ALERT_SEVERITY];
    if (Array.isArray(values) && values.length === 1) {
      const value = values[0];
      return value && typeof value === 'string' ? capitalizeFirstLetter(value) : null;
    }
    return null;
  }, [alert]);
  const color = (0, _react.useMemo)(() => (0, _helpers.getSeverityColor)(displayValue || '', euiTheme), [displayValue, euiTheme]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, displayValue && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    "data-test-subj": BADGE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, displayValue));
});
KibanaAlertSeverityCellRenderer.displayName = 'KibanaAlertSeverityCellRenderer';