"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TABLE_RELATED_INTEGRATION_CELL_RENDERER_TEST_ID = exports.KibanaAlertRelatedIntegrationsCellRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../constants");
var _integration_icon = require("../common/integration_icon");
var _type_utils = require("../../../utils/type_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alert_summary/table/kibana_alert_related_integrations_cell_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TABLE_RELATED_INTEGRATION_CELL_RENDERER_TEST_ID = exports.TABLE_RELATED_INTEGRATION_CELL_RENDERER_TEST_ID = 'alert-summary-table-related-integrations-cell-renderer';
/**
 * Renders an integration/package icon within the AI for SOC alert summary table Integration column.
 */
const KibanaAlertRelatedIntegrationsCellRenderer = exports.KibanaAlertRelatedIntegrationsCellRenderer = /*#__PURE__*/(0, _react.memo)(({
  alert,
  packages
}) => {
  const integration = (0, _react.useMemo)(() => {
    const relatedIntegration = (0, _type_utils.getAlertFieldValueAsStringOrNull)(alert, _constants.RELATED_INTEGRATION) || '';
    return packages.find(p => relatedIntegration === p.name);
  }, [alert, packages]);
  return /*#__PURE__*/_react.default.createElement(_integration_icon.IntegrationIcon, {
    "data-test-subj": TABLE_RELATED_INTEGRATION_CELL_RENDERER_TEST_ID,
    iconSize: "l",
    integration: integration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  });
});
KibanaAlertRelatedIntegrationsCellRenderer.displayName = 'KibanaAlertRelatedIntegrationsCellRenderer';