"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionStatusIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _empty_value = require("../../../../../../common/components/empty_value");
var _rule_execution_status = require("../../../../../common/components/rule_execution_status");
var _utils = require("../../../../../common/components/rule_execution_status/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_monitoring/components/basic/indicators/execution_status_indicator/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EMPTY_STATUS_TEXT = (0, _empty_value.getEmptyTagValue)();
const ExecutionStatusIndicatorComponent = ({
  status,
  showTooltip = false
}) => {
  var _getCapitalizedStatus;
  const statusText = (_getCapitalizedStatus = (0, _utils.getCapitalizedStatusText)(status)) !== null && _getCapitalizedStatus !== void 0 ? _getCapitalizedStatus : EMPTY_STATUS_TEXT;
  const statusColor = (0, _utils.getStatusColor)(status);
  return showTooltip ? /*#__PURE__*/_react.default.createElement(_rule_execution_status.RuleStatusBadge, {
    status: status,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: statusColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, statusText);
};
const ExecutionStatusIndicator = exports.ExecutionStatusIndicator = /*#__PURE__*/_react.default.memo(ExecutionStatusIndicatorComponent);
ExecutionStatusIndicator.displayName = 'ExecutionStatusIndicator';