"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertFieldValidation = assertFieldValidation;
var _react = require("@testing-library/react");
var _detection_engine = require("../../../../../../../../common/api/detection_engine");
var _rule_upgrade_helpers = require("./rule_upgrade_helpers");
var _rule_upgrade_flyout = require("./rule_upgrade_flyout");
var _set_field_value = require("./set_field_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function assertFieldValidation({
  ruleType,
  fieldName: rawFieldName,
  fieldVersions: {
    initial,
    upgrade,
    invalidValue: rawInvalidValue
  }
}) {
  // TS isn't able to infer the type of the field name for inputFieldValue()
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const invalidValue = rawInvalidValue;
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const fieldName = rawFieldName;
  describe('field value validation', () => {
    it('blocks saving field value when value is invalid', async () => {
      (0, _rule_upgrade_flyout.mockRuleUpgradeReviewData)({
        ruleType,
        fieldName,
        fieldVersions: {
          base: initial,
          current: initial,
          target: upgrade,
          merged: upgrade
        },
        diffOutcome: _detection_engine.ThreeWayDiffOutcome.StockValueCanUpdate,
        conflict: _detection_engine.ThreeWayDiffConflict.NONE
      });
      const {
        getByTestId
      } = await (0, _rule_upgrade_flyout.renderRuleUpgradeFlyout)();
      const fieldUpgradeWrapper = getByTestId(`${fieldName}-upgradeWrapper`);
      (0, _rule_upgrade_helpers.toggleFieldAccordion)(fieldUpgradeWrapper);
      (0, _rule_upgrade_helpers.switchToFieldEdit)(fieldUpgradeWrapper);
      await (0, _set_field_value.inputFieldValue)(fieldUpgradeWrapper, {
        fieldName,
        value: invalidValue
      });

      // Some fields have async validation and/or debounced validation.
      // It all makes it possible the validator function is scheduled with a delay
      // or it may be picked up by the event loop later than expected.
      // Waiting for the "Save" button to be disabled with a reasonable timeout makes sure the validation
      // has enough time to run.
      await (0, _react.waitFor)(() => expect((0, _rule_upgrade_helpers.getSaveFieldValueButton)(fieldUpgradeWrapper)).toBeDisabled(), {
        timeout: 1000
      });
    });
  });
}