"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertSuppressionReadOnly = AlertSuppressionReadOnly;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var ruleDetailsI18n = _interopRequireWildcard(require("../../../../translations"));
var _alert_suppression_label = require("../../../../../../../rule_creation_ui/components/description_step/alert_suppression_label");
var _rule_definition_section = require("../../../../rule_definition_section");
var _empty_field_value_placeholder = require("../../empty_field_value_placeholder");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_readonly/fields/alert_suppression/alert_suppression.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AlertSuppressionReadOnly({
  alertSuppression,
  ruleType
}) {
  if (!alertSuppression) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      listItems: [{
        title: ruleDetailsI18n.ALERT_SUPPRESSION_FIELD_LABEL,
        description: /*#__PURE__*/_react.default.createElement(_empty_field_value_placeholder.EmptyFieldValuePlaceholder, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 39,
            columnNumber: 26
          }
        })
      }],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 7
      }
    });
  }
  const listItems = [];
  if ('group_by' in alertSuppression) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
        label: ruleDetailsI18n.SUPPRESS_ALERTS_BY_FIELD_LABEL,
        ruleType: ruleType,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 9
        }
      }),
      description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.SuppressAlertsByField, {
        fields: alertSuppression.group_by,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 20
        }
      })
    });
  }
  if ('duration' in alertSuppression) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "alertSuppressionDurationPropertyTitle",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
        label: ruleDetailsI18n.SUPPRESS_ALERTS_DURATION_FIELD_LABEL,
        ruleType: ruleType,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.SuppressAlertsDuration, {
        duration: alertSuppression.duration,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 20
        }
      })
    });
  }
  if ('missing_fields_strategy' in alertSuppression) {
    listItems.push({
      title: /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": "alertSuppressionMissingFieldPropertyTitle",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_alert_suppression_label.AlertSuppressionLabel, {
        label: ruleDetailsI18n.SUPPRESSION_FIELD_MISSING_FIELD_LABEL,
        ruleType: ruleType,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_rule_definition_section.MissingFieldsStrategy, {
        missingFieldsStrategy: alertSuppression.missing_fields_strategy,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 9
        }
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: listItems,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 10
    }
  });
}