"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchMappingEditAdapter = ThreatMatchMappingEditAdapter;
var _react = _interopRequireDefault(require("react"));
var _threat_match_mapping_edit = require("../../../../../../../rule_creation/components/threat_match_mapping_edit");
var _use_data_view = require("../hooks/use_data_view");
var _use_diffable_rule_data_view = require("../hooks/use_diffable_rule_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/threat_match_mapping/threat_match_mapping_edit_adapter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ThreatMatchMappingEditAdapter({
  finalDiffableRule
}) {
  var _threat_index;
  const {
    dataView: ruleDataView
  } = (0, _use_diffable_rule_data_view.useDiffableRuleDataView)(finalDiffableRule);
  const {
    dataView: threatIndexPatterns
  } = (0, _use_data_view.useDataView)({
    indexPatterns: (_threat_index = finalDiffableRule.threat_index) !== null && _threat_index !== void 0 ? _threat_index : []
  });
  return /*#__PURE__*/_react.default.createElement(_threat_match_mapping_edit.ThreatMatchMappingEdit, {
    path: "threat_mapping",
    indexPatterns: ruleDataView !== null && ruleDataView !== void 0 ? ruleDataView : DEFAULT_DATA_VIEW,
    threatIndexPatterns: threatIndexPatterns !== null && threatIndexPatterns !== void 0 ? threatIndexPatterns : DEFAULT_DATA_VIEW,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  });
}
const DEFAULT_DATA_VIEW = {
  fields: [],
  title: ''
};