"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleScheduleSection = exports.AccessibleTimeValue = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _date_math = require("@kbn/securitysolution-utils/date_math");
var _to_simple_rule_schedule = require("../../../../../common/api/detection_engine/model/rule_schema/to_simple_rule_schedule");
var _accessibility = require("../../../../common/components/accessibility");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_field_name = require("./rule_field_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/rule_schedule_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AccessibleTimeValue = ({
  timeValue,
  'data-test-subj': dataTestSubj
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  "data-test-subj": dataTestSubj,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_accessibility.IntervalAbbrScreenReader, {
  interval: timeValue,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 5
  }
}));
exports.AccessibleTimeValue = AccessibleTimeValue;
const Interval = ({
  interval
}) => /*#__PURE__*/_react.default.createElement(AccessibleTimeValue, {
  timeValue: interval,
  "data-test-subj": "intervalPropertyValue",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 3
  }
});
const LookBack = ({
  value
}) => /*#__PURE__*/_react.default.createElement(AccessibleTimeValue, {
  timeValue: value,
  "data-test-subj": `lookBackPropertyValue-${value}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 3
  }
});
const RuleScheduleSection = ({
  rule,
  columnWidths = _constants.DEFAULT_DESCRIPTION_LIST_COLUMN_WIDTHS,
  ...descriptionListProps
}) => {
  var _rule$to, _descriptionListProps, _descriptionListProps2;
  if (!rule.interval || !rule.from) {
    return null;
  }
  const to = (_rule$to = rule.to) !== null && _rule$to !== void 0 ? _rule$to : 'now';
  const simpleRuleSchedule = (0, _to_simple_rule_schedule.toSimpleRuleSchedule)({
    interval: rule.interval,
    from: rule.from,
    to
  });
  const ruleSectionListItems = !simpleRuleSchedule ? [{
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "intervalPropertyTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      label: i18n.INTERVAL_FIELD_LABEL,
      fieldName: "rule_schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 15
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(Interval, {
      interval: rule.interval,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 24
      }
    })
  }, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "fromToPropertyTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      label: i18n.RULE_SOURCE_EVENTS_TIME_RANGE_FIELD_LABEL,
      fieldName: "rule_schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 15
      }
    })),
    description: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "fromToPropertyValue",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    }, i18n.RULE_SOURCE_EVENTS_TIME_RANGE((0, _date_math.normalizeDateMath)(rule.from), (0, _date_math.normalizeDateMath)(to)))
  }] : [{
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "intervalPropertyTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      label: i18n.INTERVAL_FIELD_LABEL,
      fieldName: "rule_schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 15
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(Interval, {
      interval: simpleRuleSchedule.interval,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 24
      }
    })
  }, {
    title: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "lookBackPropertyTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_rule_field_name.RuleFieldName, {
      label: i18n.LOOK_BACK_FIELD_LABEL,
      fieldName: "rule_schedule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 15
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(LookBack, {
      value: simpleRuleSchedule.lookback,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 24
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "listItemColumnStepRuleDescription",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, (0, _extends2.default)({
    type: (_descriptionListProps = descriptionListProps.type) !== null && _descriptionListProps !== void 0 ? _descriptionListProps : 'column',
    rowGutterSize: (_descriptionListProps2 = descriptionListProps.rowGutterSize) !== null && _descriptionListProps2 !== void 0 ? _descriptionListProps2 : 'm',
    listItems: ruleSectionListItems,
    columnWidths: columnWidths
  }, descriptionListProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  })));
};
exports.RuleScheduleSection = RuleScheduleSection;