"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataViewIdValidatorFactory = dataViewIdValidatorFactory;
exports.isDataViewIdValid = isDataViewIdValid;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function dataViewIdValidatorFactory() {
  return (...args) => {
    const [{
      path,
      value
    }] = args;
    return !isDataViewIdValid(value) ? {
      path,
      message: _i18n.i18n.translate('xpack.securitySolution.ruleManagement.ruleCreation.validation.dataView.requiredError', {
        defaultMessage: 'Please select an available Data View.'
      })
    } : undefined;
  };
}
function isDataViewIdValid(dataViewId) {
  return typeof dataViewId === 'string' && dataViewId !== '';
}