"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EllipsisText = void 0;
exports.TruncatableText = TruncatableText;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/truncatable_text/truncatable_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Applies CSS styling to enable text to be truncated with an ellipsis.
 * Example: "Don't leave me hanging..."
 *
 * Note: Requires a parent container with a defined width or max-width.
 */

const EllipsisText = exports.EllipsisText = _styledComponents.default.span`
  &,
  & * {
    display: inline-block;
    max-width: 100%;
    overflow: hidden;
    text-overflow: ellipsis;
    vertical-align: top;
    white-space: nowrap;
  }
`;
EllipsisText.displayName = 'EllipsisText';
function TruncatableText({
  tooltipContent,
  children,
  dataTestSubj,
  ...props
}) {
  if (!tooltipContent) return /*#__PURE__*/_react.default.createElement(EllipsisText, (0, _extends2.default)({
    "data-test-subj": dataTestSubj
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }), children);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    display: "block",
    content: tooltipContent,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(EllipsisText, (0, _extends2.default)({
    "data-test-subj": dataTestSubj
  }, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), children));
}