"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReferenceErrorModalComponent = exports.ReferenceErrorModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _polished = require("polished");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/reference_error_modal/reference_error_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MarkdownContainer = _styledComponents.default.div`
  max-height: 200px;
  overflow-y: auto;

  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }

  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }

  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
const ReferenceErrorModalComponent = ({
  cancelText,
  confirmText,
  contentText,
  onClose,
  onCancel,
  onConfirm,
  references = [],
  showModal,
  titleText
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!showModal) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    maxWidth: 460,
    "aria-labelledby": modalTitleId,
    title: titleText,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: cancelText,
    confirmButtonText: confirmText,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    "data-test-subj": "referenceErrorModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, contentText), /*#__PURE__*/_react.default.createElement(MarkdownContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    gutterSize: "none",
    showToolTips: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, references.map((r, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: `${index}-${r}`,
    label: r,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  })))));
};
exports.ReferenceErrorModalComponent = ReferenceErrorModalComponent;
ReferenceErrorModalComponent.displayName = 'ReferenceErrorModalComponent';
const ReferenceErrorModal = exports.ReferenceErrorModal = /*#__PURE__*/_react.default.memo(ReferenceErrorModalComponent);
ReferenceErrorModal.displayName = 'ReferenceErrorModal';