"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Panel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * The reason for the type of syntax below of:
 * `styled(({ loading, ...props })`
 * is filter out the "loading" attribute from being put on the DOM
 * and getting one of the stack traces from
 * ```
 * ReactJS about non-standard HTML such as this one:
 * Warning: Received `true` for a non-boolean attribute `loading`.
 * If you want to write it to the DOM, pass a string instead: loading="true" or loading={value.toString()}.
 * ```
 *
 * Ref: https://github.com/styled-components/styled-components/issues/1198#issuecomment-425650423
 * Ref: https://github.com/elastic/kibana/pull/41596#issuecomment-514418978
 * Ref: https://www.styled-components.com/docs/faqs#why-am-i-getting-html-attribute-warnings
 * Ref: https://reactjs.org/blog/2017/09/08/dom-attributes-in-react-16.html
 */
const Panel = exports.Panel = (0, _styledComponents.default)(({
  loading,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({}, props, {
  hasBorder: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 28,
    columnNumber: 56
  }
})))`
  position: relative;
  ${({
  loading
}) => loading && `
    overflow: hidden;
  `}
`;
Panel.displayName = 'Panel';