"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createJobKey = exports.AnomalyScoresComponent = exports.AnomalyScores = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _empty_value = require("../../empty_value");
var _get_top_severity = require("./get_top_severity");
var _anomaly_score = require("./anomaly_score");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml/score/anomaly_scores.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createJobKey = score => `${score.jobId}-${score.severity}-${score.entityName}-${score.entityValue}`;
exports.createJobKey = createJobKey;
const AnomalyScoresComponent = ({
  anomalies,
  startDate,
  endDate,
  isLoading,
  narrowDateRange,
  limit,
  jobNameById
}) => {
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": "anomaly-score-spinner",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 12
      }
    });
  } else if (anomalies == null || anomalies.anomalies.length === 0) {
    return (0, _empty_value.getEmptyTagValue)();
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      responsive: false,
      "data-test-subj": "anomaly-scores",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }, (0, _get_top_severity.getTopSeverityJobs)(anomalies.anomalies, limit).map((score, index) => {
      var _jobNameById$score$jo;
      const jobKey = createJobKey(score);
      return /*#__PURE__*/_react.default.createElement(_anomaly_score.AnomalyScore, {
        key: jobKey,
        startDate: startDate,
        endDate: endDate,
        index: index,
        score: score,
        jobName: (_jobNameById$score$jo = jobNameById[score.jobId]) !== null && _jobNameById$score$jo !== void 0 ? _jobNameById$score$jo : score.jobId,
        interval: anomalies.interval,
        narrowDateRange: narrowDateRange,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 15
        }
      });
    })));
  }
};
exports.AnomalyScoresComponent = AnomalyScoresComponent;
AnomalyScoresComponent.displayName = 'AnomalyScoresComponent';
const AnomalyScores = exports.AnomalyScores = /*#__PURE__*/_react.default.memo(AnomalyScoresComponent);
AnomalyScores.displayName = 'AnomalyScores';