"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MarkdownRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _unified = _interopRequireDefault(require("unified"));
var _i18nReact = require("@kbn/i18n-react");
var _plugins = require("./plugins");
var _markdown_link = require("./markdown_link");
var _kibana = require("../../lib/kibana");
var _use_license = require("../../hooks/use_license");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/markdown_editor/renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MarkdownRendererComponent = ({
  children,
  disableLinks,
  textSize = 'm'
}) => {
  const MarkdownLinkProcessingComponent = (0, _react.useMemo)(
  // eslint-disable-next-line react/display-name
  () => props => /*#__PURE__*/_react.default.createElement(_markdown_link.MarkdownLink, (0, _extends2.default)({}, props, {
    disableLinks: disableLinks,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 22
    }
  })), [disableLinks]);
  // Deep clone of the processing plugins to prevent affecting the markdown editor.
  const processingPluginList = (0, _fp.cloneDeep)(_plugins.processingPlugins);
  // This line of code is TS-compatible and it will break if [1][1] change in the future.
  processingPluginList[1][1].components.a = MarkdownLinkProcessingComponent;
  const isPlatinum = (0, _use_license.useLicense)().isAtLeast('platinum');
  const {
    application
  } = (0, _kibana.useKibana)().services;
  const platinumPluginDetected = (0, _react.useMemo)(() => {
    if (isPlatinum === false) {
      const markdownString = String(children);
      return _plugins.platinumOnlyPluginTokens.some(token => {
        const regex = new RegExp(token);
        return regex.test(markdownString);
      });
    } else {
      return false;
    }
  }, [children, isPlatinum]);
  const processor = (0, _react.useMemo)(() => (0, _unified.default)().use(_plugins.parsingPlugins).use(processingPluginList), [processingPluginList]);
  const markdownParseResult = (0, _react.useMemo)(() => {
    try {
      processor.processSync(children);
      return null;
    } catch (err) {
      return String(err.message);
    }
  }, [children, processor]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, platinumPluginDetected && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.PLATINUM_WARNING,
    color: "primary",
    iconType: "lock",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.markdown.premiumPluginLinkPrefix",
    defaultMessage: "To use these interactive markdown features, you must {link}.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: application.getUrlForApp('management', {
          path: 'stack/license_management/home'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.markdown.premiumPluginLinkSuffix",
        defaultMessage: "start a trial or upgrade your subscription",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 21
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  })), markdownParseResult !== null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.INVALID_MARKDOWN,
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, markdownParseResult), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    parsingPluginList: _plugins.parsingPlugins,
    processingPluginList: processingPluginList,
    textSize: textSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, children));
};
MarkdownRendererComponent.displayName = 'MarkdownRendererComponent';
const MarkdownRenderer = exports.MarkdownRenderer = /*#__PURE__*/(0, _react.memo)(MarkdownRendererComponent);